/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __wxContour_ListViewPanel_h_INCLUDED_H__
#define __wxContour_ListViewPanel_h_INCLUDED_H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <wx/listctrl.h>

//------------------------------------------------------------------------------------------------------------
// Events declaration
//------------------------------------------------------------------------------------------------------------
/*BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE( wxEVT_CONCEPT_RELEASE, -1 )	
END_DECLARE_EVENT_TYPES()*/

/** file wxContour_ListViewPanel.h */

class wxContour_ControlPanel;
//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------
class wxContour_ListViewPanel : public wxListCtrl {

		public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	wxContour_ListViewPanel(wxWindow *parent,const wxWindowID id, const wxPoint& pos,const wxSize& size,long style);

	~wxContour_ListViewPanel();

	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events
	//------------------------------------------------------------------------------------------------------------
	 void InsertItemInReportView(int i);

    void OnColClick(wxListEvent& event);
    void OnColRightClick(wxListEvent& event);
    void OnColBeginDrag(wxListEvent& event);
    void OnColDragging(wxListEvent& event);
    void OnColEndDrag(wxListEvent& event);
    void OnBeginDrag(wxListEvent& event);
    void OnBeginRDrag(wxListEvent& event);
    void OnBeginLabelEdit(wxListEvent& event);
    void OnEndLabelEdit(wxListEvent& event);
    void OnDeleteItem(wxListEvent& event);
    void OnDeleteAllItems(wxListEvent& event);

    void OnGetInfo(wxListEvent& event);
    void OnSetInfo(wxListEvent& event);

    void OnSelected(wxListEvent& event);
    void OnDeselected(wxListEvent& event);
    void OnListKeyDown(wxListEvent& event);
    void OnActivated(wxListEvent& event);
    void OnFocused(wxListEvent& event);
    void OnCacheHint(wxListEvent& event);

    void OnChar(wxKeyEvent& event);

    void OnContextMenu(wxContextMenuEvent& event);
	void OnRightClick(wxMouseEvent& event);
		
	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------
	void sendEnvent( WXTYPE theEventType );


	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
	
	void setContainerParent( wxContour_ControlPanel * theBuilder);


	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

private:
	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------


	void ShowContextMenu(const wxPoint& pos);
    wxLog *m_logOld;
    void SetColumnImage(int col, int image);

	/*
    void LogEvent(const wxListEvent& event, const wxChar *eventName);
    void LogColEvent(const wxListEvent& event, const wxChar *eventName);
	*/

    virtual wxString OnGetItemText(long item, long column) const;
    virtual int OnGetItemColumnImage(long item, long column) const;
    virtual wxListItemAttr *OnGetItemAttr(long item) const;

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

		
	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------
	wxContour_ControlPanel * containerParent;

	wxListItemAttr itemsStyle;

};
#endif // __wxContour_ListViewPanel_HEADER_FILE__

