/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

//	MACRO

#ifndef __SOMEENVIRONMENT_H_INCLUDED__
#define  __SOMEENVIRONMENT_H_INCLUDED__

// SYSTEM INCLUDES

	#include <iostream>
	#include <map>
	#include <vector>
	#include <string>


// PROJECT INCLUDES


// LOCAL INCLUDES

#include "SomeThing.h"


// FORWARD REFERENCES

/*
*	COMMENT
*	@param
*	@return
*/



template <class T>
	
class SomeEnvironment
	{
				public:
						//====== LIFECYCLE ========
						SomeEnvironment();

						SomeEnvironment(std::map<std::string,int>* concepts,std::map< std::string,SomeThing<T> >* things);
						
						~SomeEnvironment();
							
						//====== OPERATIONS =======
						/*
						*	Adds a thing to the program
						*	@param name: name of the thing
						*	@param thing: thing to be added
						*	@return true if the thing was succesfully added
						*/
						

						bool addThing(std::string name,T thing);
							
						
						/*
						*	Add thing with the name given to the instant given
						*	PRECONDITION
						*	the thing that has that name IS ALREADY ADDED TO THE PROGRAM
						*	@param name: name of the EXISTANT thing
						*	@param instant: instant associated to the thing
						*	@return true if the thing was succesfully added
						*/

						bool addInstantToThing(std::string name,Instant* instant);
							
						/*
						*	Add thing with the name given, and the data given in the instant given
						*	@param name: name of the thing
						*	@param thing: information of the thing to be added
						*	@param instant: instant associated to the thing
						*	@return true if the thing was succesfully added
						*/

						bool addThingWithInstant(std::string name,T thing,Instant* instant);
							
						/*
						*	Add a concept to the environment
						*	@param name: name of the concept
						*	@param size: size of the concept, it means that its indexes are
						*				 distributed 0..size-1
						*	@return true if succesful, false otherwise
						*/
						
					
						bool addConcept(std::string name, int size);

						//bool addConceptToThing(std::string nameConcept,std::string nameThing,int indexInConcept);
							
						/*
						* Validate the index of a concept in an instant
						*/
						bool isValidIndex(int index, int indexInInstant);

						//====== INQUIRY =========
						
						/*
						*	Get the things of that instant
						*	@param instant: the instant for wich we need to know its things
						*	@return thingsOfInstant: a vector with the pointers to the things
						*	of the instant asked
						*/
						std::vector<T*>* getThings(Instant* instant);
						
						/*
						*	Returns the things with their names in the environment
						*	@param names, vector where is goint to be safe the names 
						*	of the things in the environment.
						*	@param things, vector where is going to be save the things
						*	@parama instant, instant for wich
						*	@return
						*/
						void getThings(std::vector<std::string>& names,std::vector<T*>& thingsVector,Instant* instant);
						
						/*
						*	Returns the instants where the thing identified by the name
						*	it should appears
						*	@param nameThing, name of the thing in the environment
						*	@return instants of that thing
						*	NOTE SENDS THE POINT TO A COPY OF THE VECTORS OF INSTANTS
						*/
						
						std::vector<Instant*>* getInstantsOfThing(std::string nameThing);

						/*
						*	Returns the instants define in the environment
						*	@return existing instants in the environment
						*/
						
						std::vector<Instant*>* getExistingInstants();

						/*
						*	Returns the size of the concept identified by nameConcept
						*	@param nameConcept, name of the concept in the environment
						*	@return size, of the concept given
						*/
						int getSizeConcept(std::string nameConcept);

						/*
						* returns the index of the  concept in the instants
						*/
						int getIndexConcept(std::string nameConcept);
					
						/*
						*	Give the names of the names defined
						*	@param nameConcepts, vector where is goin to be save the names of the concepts
						*/
						void getConceptsNames(std::vector<std::string>& namesConcepts);

						/*
						*	Method that retorns the name of each concept and the size of it.
						*	@param conceptNameVect, Vector in which is disposed to be setted the name for each of the included concepts
						*	@param conceptSizeVect, Vector in which is disposed to be setted the size for each of the included concepts
						*/
						void getConceptsInformation(std::vector<std::string>& conceptNameVect, std::vector<int>& conceptSizeVect);
					
						/*
						* returns all the things of the environment
						* @param vector where is going to be charge the things
						* PRECONDITION
						*  thingsVector is empty
						*/
						void getThingsOfEnvironment(std::vector<T*>* thingsVector);

						/*
						* returns a pointer to the thing with the name given
						*/
						T* getThingByName(std::string name);
						/*
						* returns the number of concepts defined
						*/
						int getNumberOfConcepts();

						/*
						* Gets the number of things 
						* @return Returns the number of existing things in the environment
						*/
						int getNumberOfThings ();

						//====== ACCESS ==========
						/*
						*	Remove a thing from all the instants, it means from the program
						*	@param name: name of the thing
						*	@return: true if the removed is succesful (false if the thing doesnt exist)
						*/
						
						bool removeThing(std::string name);
							
						/*
						*	Removes the thing with the name given, from the instant
						*	given
						*	@param name: name of the thing
						*	@param Instant: Instant from which it will be removed
						*	@return true: if the removed is succesful (false if the thing doesn exist)
						*/
						
						bool removeThingFromInstant(std::string name, Instant* instant);
							

						/*
						*	Remove Instant from the program, it means, that from all the
						*	somethings that have that instant, after call this method them 
						*	doesnt have that instant anymore
						*	@param instant: instant that is going to be removed
						*	@return true: if the removed is succesful (false other wise)
						*/
						bool removeInstant(Instant* instant);
						

						/*
						*	TODO
						*	Change the instant (any index of any concept) for all the things
						*	that should be find in that instant
						*	@param indexInstant: index of the instant in the existing instants
						*	in the environment
						*	@param indexConcept: index of the concept in the instant to be changed
						*	@param indexInConcept: which value between 0-sizeConcept is going to be saved
						*	@return 
						*/
						void changeInstantForAllThings(int indexInstant, int indexConcept, int indexInConcept);

						
						//void changeInstantOnlyForThing(std::string nameThing, Instant* instant, int indexConcept,);
						/*
						*	Remove a dimension from the environment
						*	THE REMOVE OF THE CONCEPT IS WHEN IS BEING DEFINED THE ENVIRONMENT ,NO IN
						*	EXECUTION
						*	PRECONDITION
						*	the name of the concept given is already added to the environment
						*	@param nameConcept, name of the concept to remove
						*/
							
						bool removeConcept(std::string nameConcept);
						

						
				private:
					
					//======= ATTRIBUTES=======
					
					/*
					*	Concepts that was defined
					*	Saving in like (nameConcept,sizeConcept), where the key 
					*	is the name of the concept
					*/
					
					std::map<std::string,int>		concepts;
					/*
					*	The things that this concepts handle
					*	EXAMPLE
					*	in visualization the concepts handle actors, it means that 
					*	the actor are them things, but things also store the thing's name
					*	PRECONDITION
					*	each thing has a unique name, and is stored like (nameThing,Thing)
					*	where the key is the name of the thing
					*/
				
					std::map < std::string,SomeThing<T> >	 things;
					
					/*
					*	this is the things of the instant asked
					*	use for returning the data
					*/
					std::vector<T*> thingsOfInstant;
					
					/*
					*	this vector saves the instants that
					*	are defined in the Environment
					*/
					std::vector<Instant*> existingInstants;

					/*
					* is the relation between the  the indexes of the instants and the 
					* concepts in the environment
					*/
					std::map<std::string,int> indexesConcepts;

					//====== PRIVATE METHODS=========
						/*
						*	Checks if in the instant given the something given has it
						*	@param instant, instant to check
						*	@param something;, something to check in the instant
						*	@return
						*/
						bool isInInstant(SomeThing<T>* something,Instant *instant);
						
						/*
						*	Remove the instant from the environment
						*	@param instant, to be erased
						*	@return
						*/
						void removeInstantFromExistingInstants(Instant* instant);
						
						/*
						*	Adds an instant to the existing instants, verifying if
						*   the instant is already added
						*	@param instant, to be added
						*	@return the index of that instant in the existing instants in the 
						*	environment
						*/
						int addInstant(Instant* instant);
						/*
						*	Return the index in the existing instants of the instant 
						*	that the user had given
						*	@param instant, instant for which we are looking the index in
						*	the  existings intants in the environment
						*	@return an index in (0,existingInstants.size()-1)
						*/
						int getIndexInstantInExistingInstants(Instant* instant);
			

					
					
					

	};
//include the implementation of the template
#include "SomeEnvironment_Txx.h"
#endif
