/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef __creaImageIOTree_h_INCLUDED__
#define __creaImageIOTree_h_INCLUDED__

#include <creaImageIOTreeNode.h>
#include <creaImageIOTreeDescriptor.h>

namespace creaImageIO
{

  namespace tree
  {
    /**
     * \ingroup Tree
     */
    //=====================================================================
    /// Abstract class to store user data on a Tree
    struct TreeData
    { 
      TreeData() {}
      virtual ~TreeData() {}
    };
    //=====================================================================
    
    //=====================================================================
    /// An attributed Tree structure
    /** \ingroup Tree
     */
    class Tree : public Node
    {
    public:
      /// Ctor
      Tree();
      /// Virtual destructor
      virtual ~Tree();
      
      /// Returns the descriptor of the tree
    
      /// Returns the tree to which the node belongs
      virtual Tree* GetTree() { return this; }
      /// Returns the tree to which the node belongs
      virtual const Tree* GetTree() const { return this; }
      /// Returns the level of the node in the tree
      virtual int GetLevel() const { return 0; }
      
      /// Returns the Descriptor of the tree (const)
      const Descriptor& GetDescriptor() const { return mDescriptor; }
      /// Returns the descriptor of the tree 
      Descriptor& GetDescriptor() { return mDescriptor; }

     /// Returns the number of levels of the tree
      unsigned int GetNumberOfLevels() 
      { return GetDescriptor().GetNumberOfLevels(); }

      /// Returns the LevelDescriptor of a given level (const ref)
      const LevelDescriptor& GetLevelDescriptor(int level) const
      { return GetDescriptor().GetLevelDescriptor(level); }

      /// Returns the AttributeDescriptorList of a given level (const ref)
	  /// type = 0 all attributes
	  /// type = 1 without ID and PATIENT_ID
      const LevelDescriptor::AttributeDescriptorListType& 
      GetAttributeDescriptorList(int level, int type = 0) const
      { return GetDescriptor().GetAttributeDescriptorList(level, type); }
  
      virtual void Print() const;


	  /// Copy descriptor list without ID tag
	  void CopyAttributeDescriptorList(int level)
	  {
		  GetDescriptor().CopyAttributeDescriptorList(level);
	  }
	  
	  /// Test if this attribute is available in this tree description
	  const std::string isAttributeExist(const std::string i_attr)
	  {
		  return mDescriptor.isExist(i_attr);
	  }

    private:
      Descriptor mDescriptor;

    };
    // EO class Tree
    //=====================================================================

  } // EO namespace tree
  
} // EO namespace creaImageIO

// EOF
#endif  
