/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef __creaImageIOTreeLevelDescriptor_h_INCLUDED__
#define __creaImageIOTreeLevelDescriptor_h_INCLUDED__

#include <creaImageIOTreeAttributeDescriptor.h>
#include <vector>

namespace creaImageIO
{

  namespace tree
  {
	/**
	* \ingroup Tree
	*/
    //=====================================================================
    /// Descriptor of a level of a Tree (name, attributes, ...)
    class LevelDescriptor
    {
    public:
      /// Ctor with name
      LevelDescriptor(const std::string& name) : mName(name) {}
      /// Destructor
      ~LevelDescriptor() {} 

      /// Returns the name of the level
      const std::string& GetName() const { return mName; }

      /// Returns the number of attributes of the level
      unsigned int GetNumberOfAttributes() const
      { return (int)mAttributeDescriptorList.size(); }

      /// Adds the AttributeDescriptor to the list
      void Add(const AttributeDescriptor&);

	  /// The type of attribute container
      typedef std::vector<AttributeDescriptor> AttributeDescriptorListType;
 
      /// Returns the list of AttributeDescriptor (const)
	    /// type = 0 all attributes
	  /// type = 1 without ID and PATIENT_ID
      const AttributeDescriptorListType& GetAttributeDescriptorList(int type = 0) const 
      {	if (type == 0)
		  return mAttributeDescriptorList; 
		else 
			return mAttributeDescriptorListWID;
	  }

	  /// Copy the original list of attributes
	  void CopyAttributeDescriptorList();

      /// \return The list of attributes with flag IDENTIFIER set
      const std::vector<std::string>& GetIdentifierList() const 
      { return mIdentifierList; }
      /// \return The list of attributes with flag LABEL set
      const std::vector<std::string>& GetLabelList() const 
      { return mLabelList; }

    private:
      std::string mName;
	  // Attributes List for this level
      AttributeDescriptorListType mAttributeDescriptorList;
	  // Attributes List for this level without ID and PARENT_ID attributes
	  AttributeDescriptorListType mAttributeDescriptorListWID;
      /// The list of attributes with flag IDENTIFIER set
      std::vector<std::string> mIdentifierList;
      /// The list of attributes with flag LABEL set
      std::vector<std::string> mLabelList;

    };
    // EO class LevelDescriptor
    //=====================================================================
  }// EO namespace tree
  

} // EO namespace creaImageIO

// EOF
#endif  
