/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOWxDumpPanel_h_INCLUDED__
#define __creaImageIOWxDumpPanel_h_INCLUDED__

#ifdef USE_WXWIDGETS
#include <creaWx.h>
#include <creaImageIOWxGimmickView.h>

#define DUMP_SAVE_ID 1800


namespace creaImageIO
{
  /**
   * \ingroup GUI
   */
  //=====================================================================
 //=====================================================================
  /// Display all dicom tags from a given DICOM file
	class WxDumpPanel : public wxDialog
  {
  public:

    /// Constructor
	WxDumpPanel(wxWindow *parent, std::string i_filename);
    
	/// Destructor
    ~WxDumpPanel();
	
	
  private :

	 const std::string clean(const std::string &i_line);
    /// Display in a control Text all dicom tags
	void Print();

	/// wxEvent to save Dicom Tags in a text file
	 void SaveInfos(wxCommandEvent& event);

   /// Parent DialogBox
	wxDialog* dialog;

	/// Icons list
	wxImageList *mIcon;

	/// ControlText to display tags
	wxTextCtrl *DumpText;

	/// Dicom file to display
	std::string filename;

    DECLARE_EVENT_TABLE()

  }; // class WxEditFieldsPanel
  //=====================================================================

  
} // EO namespace creaImageIO


#endif // USE_WIDGETS
// EOF
#endif

