/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef CUTTINGMODELFIGURE_H_
#define CUTTINGMODELFIGURE_H_

#include "vtkTransform.h"
#include "vtkPolyData.h"

class CutModelFigure
{
public:
	CutModelFigure(){}	
	
	virtual ~CutModelFigure(){}

	virtual void SetPosition(double x,double y, double z){
		_px = x;
		_py = y;
		_pz = z;
	}

	virtual void	SetScale(double sx,double sy, double sz){
		_sx = sx;
		_sy = sy;
		_sz = sz;
	}

	virtual void	SetRotation(double alfa,double beta, double teta){
        _alfa = alfa;
		_beta = beta;
		_teta = teta;
	}

	virtual void	SetSpacing(double spcX,double spcY, double spcZ){
		_spcX = spcX;
		_spcY = spcY;
		_spcZ = spcZ;
	}		

	virtual void SetVtkTransform(vtkTransform *transform){
		double *orient = transform->GetOrientation();
		_alfa = orient[0];
		_beta = orient[1];
		_teta = orient[2];

		double *scale = transform->GetScale();
		_sx = scale[0];
		_sy = scale[1];
		_sz = scale[2];

		double *position = transform->GetPosition();
		_px = position[0];
		_py = position[1];
		_pz = position[2];


	}
	virtual void SetInversVtkTransform(vtkTransform *inverstransform){
		_inversModel = inverstransform;
	}

	virtual bool IfPointInside(double x, double y, double z) = 0;
	virtual double	GetTheoricVolume()=0;	
	virtual vtkPolyData* getPolyData()=0;

private:
	double			_px;
	double			_py;
	double			_pz;
	double			_alfa;
	double			_beta;
	double			_teta;
	double			_spcX;
	double			_spcY;
	double			_spcZ;
	char *GetName;
protected:
	double			_sx;
	double			_sy;
	double			_sz;
	vtkTransform	*_inversModel;
	vtkTransform	*_matrixModel;	
};

#endif /*FIGURECUTTINGMODEL_H_*/
