/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef _FILL_FILTER_H_
#define _FILL_FILTER_H_

#include "baseFilterManualPaint.h"

class FillFilter : public baseFilterManualPaint {
public:
	FillFilter();
	virtual ~FillFilter();

    void Run();
    void FillToolRecursive(int px,int py, int pz);

    void SetToleranceFill(double tolerancefill);
    void SetDistanceFill(int distancefill);
    void SetRangeMin( int min );//DFCH
    void SetRangeMax( int max );//DFCH
    int GetRangeMin( ); //DFCH
    int GetRangeMax( ); //DFCH
    virtual void SetImage(vtkImageData *image);

private:
    double          _tolerancefill;
    int             _distancefill;
    double          _graylevelbasefill;

    int             _pxfill;
    int             _pyfill;
    int             _pzfill;
    double          _distbasefill;
    double          _tmpDistfill;
    double          _tmpiglfill;
    long int        _countRecursiveFill;
    long int        _countRecursiveFillProblem;
    vtkImageData    *_auxImageFill;
    bool             _usingAuxImageFill;
    bool             _auxGrayLevelValidationFill;
    long int        _countProgressingFill;
    long int        _limitRecursionFill;
    int    			_RangeMin;
    int    			_RangeMax;
    void    SetAuxImageFill(int px,int py, int pz);

protected:

};


#endif // _FILL_FILTER_H_
