/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/**
 *  \file
 *  \brief Class ThresholdImageView .
 */

/**
 * \class ThresholdImageView
 * \brief
 */

#ifndef __LayerImageBase_h__
#define __LayerImageBase_h__

#include <vtkImageReslice.h>
#include <vtkLookupTable.h>
#include <vtkImageMapToColors.h>
#include <vtkImageActor.h>
#include <vtkImageData.h>
#include "wxVtkBaseView.h"
#include "vtkScalarBarActor.h"

#include "InteractorStyleMaracas.h"

//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------
class LayerImageBase;

class ColorLayerImageBasevtkInteractor : public InteractorStyleMaracas 
{
public:
	ColorLayerImageBasevtkInteractor(LayerImageBase* layerImageBase);
	virtual ~ColorLayerImageBasevtkInteractor();

	virtual bool OnChar(); 
	virtual bool OnMouseMove();
	virtual bool OnRightButtonDown();
	virtual bool OnRightButtonUp();

private:
    bool					_state;
    bool 				_stateKey;
    LayerImageBase* 	_layerImageBase;

protected:

};


//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------



class LayerImageBase
 {
  public:
		LayerImageBase();
		virtual ~LayerImageBase();
		void SetX(int x);
		void SetY(int y);
		void SetZ(int z);
		void SetImage(vtkImageData* image);
		void SetRangeForColorBar(std::vector<double> &range);
		void GetRangeForColorBar(double &minRange, double &maxRange);
		void SetwxVtkBaseView(wxVtkBaseView *baseview);

		void onThreshold();
		void onThresholdChange();
		void onThresholdInterpolation(bool interpolate);
		void onThresholdChangeOpacity (int opacity);
		void onThresholdRemove();
		wxVtkBaseView *GetwxVtkBaseView();
		void Refresh();
		vtkLookupTable *GetvtkLookupTable();
		vtkImageReslice *GetvtkImageReslice();
		virtual int GetX();
		virtual int GetY();
		virtual int GetZ();
		bool GetActorPresent();
		void GetImageScalarRange();


  private:
		int						_X;
		int						_Y;
		int						_Z;
		bool					_actorPresent;
		vtkImageData			*_image;
		vtkImageReslice			*_imageReslicer;
		vtkLookupTable			*_thresholdTable;
		vtkImageMapToColors		*_thresholdMapper;
		vtkImageActor			*_thresholdActor;
		wxVtkBaseView			*_baseView;

		vtkScalarBarActor		*_scalarbarActor;

		virtual void 			ConfigLookupTable() = 0;		
		void		 			CleanXYZ(double &x, double &y, double &z);


  protected:
		vtkLookupTable			*GetThresholdTable();
		vtkImageData			*GetImage();
	  	double 					_range[2];
	  	std::vector<double> 	_rangeForColorBar;
 };



#endif  // __LayerImageBase_h__

