/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef _MANUAL_PAINT_MODEL_H_
#define _MANUAL_PAINT_MODEL_H_

#include "BrushFilter.h"
#include "FillFilter.h"

//#include "regionStructUR.h"
//#include "imageUndoRedo.h"

#include "imageModificationManager.h"
#include "imageUndoRedo.h"


class ManualPaintModel {
public:
	ManualPaintModel();
	virtual ~ManualPaintModel();

	void SetActive(bool active);
	void SetTool(int tool);
	void Set2D3D(int dim2D3D);
	void SetImage(vtkImageData *image);
	void SetGrayLevel(double graylevel);
	void SetDirection(int direction);
	void SetBrushSize(int brushsize);
	void SetBrushForm(int brushform);
	void SetToleranceFill(double tolerancefill);
	void SetDistanceFill(int distancefill);
	void PaintImage(int px, int py, int pz);
	void SetRangeMin(int min);
	void SetRangeMax(int max);
	void GetScalarRange(double * range);
	void SetUndoImage(); //DFCH
	void Undo(); //DFCH
	void Redo(); //DFCH

private:
	int _tool;
	bool _active;
	BrushFilter *_brushfilter;
	FillFilter *_fillfilter;
	ImageUndoRedo *_imageUndoRedo;

protected:

};

#endif // _MANUAL_PAINT_MODEL_H_
