/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	imageMManager.h
 * @brief	This file contains the ImageMManager class.
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#ifndef IMAGEMANAGEMENT_H_
#define IMAGEMANAGEMENT_H_

#include <iostream>
#include <map>
#include <limits>

#include "regionStructUR.h"

/*! @class ImageMManager imageMManager.h "imageMManager.cxx"
 *	@brief This class contains the modification manager of the undo/redo
 *	@details This class contains the region and some information about the undo/redo
 */
class ImageMManager {
public:
	// ----------------------------------------------------------------------------------
	/*! @fn ImageMManager();
	 * @brief This is the default constructor.
	 */
	ImageMManager();
	// ----------------------------------------------------------------------------------
	/*! @fn ImageMManager(ImageMManager* manager);
	 * @brief This is the parameterized constructor.
	 */
	ImageMManager(ImageMManager* manager);
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ~ImageMManager();
	 * @brief This is the destructor.
	 */
	virtual ~ImageMManager();
	// ----------------------------------------------------------------------------------
	/*! @fn void CleanModifiedRegion();
	 * @brief This method cleans the modification Region.
	 */
	void CleanModifiedRegion();
	// ----------------------------------------------------------------------------------
	/*! @fn void AddModifiedPixel(const int& i, const int& j, const int& k);
	 * @brief This method adds the coordinates of the region modified.
	 */
	void AddModifiedPixel(const int& i, const int& j, const int& k);
	// ----------------------------------------------------------------------------------
	/*! @fn bool ValidateRegion();
	 * @brief This method returns true if the region modified is valid.
	 * @return
	 */
	bool ValidateRegion();
	// ----------------------------------------------------------------------------------
	/*! @fn RegionStructUR GetModifiedRegion();
	 * @brief This method returns the modification region.
	 * @return
	 */
	RegionStructUR GetModifiedRegion();
	// ----------------------------------------------------------------------------------
private:
	// ----------------------------------------------------------------------------------
	/*! @fn
	 * @brief This method make the calculation of the minimun and maximum of the region modified.
	 */
	void CalculateMinMaxRegion(const int& i, const int& j, const int& k);
	// ----------------------------------------------------------------------------------
private:
	RegionStructUR m_RegionStruct; //!< This is the Region structure.
	bool m_ValidRegion; //!< This is true if the region is valid.
};

#endif /* IMAGEMANAGEMENT_H_ */
