/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualContour3VControler_h
#define manualContour3VControler_h

#include "wxMPRBaseData.h"
#include "manualContourControler.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class creaMaracasVisu_EXPORT manualContour3VControler:  public manualContourControler
{
public:
	manualContour3VControler(int type);
	virtual ~manualContour3VControler();
	virtual manualContour3VControler * Clone();
	void CopyAttributesTo( manualContour3VControler *cloneObject );

	virtual bool	OnChar();   	
	virtual void	AddPoint(int x, int y, int z);
	virtual void	InsertPoint(int x, int y, int z);
	virtual void	MouseMove(int x, int y);
	virtual void	ResetContour();

	void AddManualViewBaseContour( manualViewBaseContour *manViewBaseCont );

	vtkMPRBaseData	*GetVtkMPRBaseData();
			void	SetVtkMPRBaseData (vtkMPRBaseData *vtkmprbasedata );
	virtual void	SetPoint( int id ,int x ,int y ,int z );

	virtual void	DeleteActualMousePoint(int x, int y);

			void	AddPoint_Others();
			void	DeleteActualMousePoint_Others(int id);
			void	MouseMove_Others(int id);
			void	InsertPoint_Others(int id);
			void	OnChar_Others();
			void	ResetContour_Others();
			int		GetType();

private:
	int _type;

	vtkMPRBaseData		  *_vtkmprbasedata; 

	std::vector< manualViewBaseContour* > _lstManualViewBaseContour;
};


#endif // manualContour3VControler_h
