/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualContourModelBullEye_h
#define manualContourModelBullEye_h

#include "manualContourModel.h"
#include "manualContourModelBullEyeSector.h"

//--------------------------------------------------------
//eed004
class creaMaracasVisu_EXPORT manualContourModelBullEye : public manualContourModel
{
public:
	manualContourModelBullEye();
	virtual ~manualContourModelBullEye();
	virtual manualContourModelBullEye *Clone();
	void	CopyAttributesTo( manualContourModelBullEye *cloneObject);
	virtual void Save(FILE *ff);
	virtual void Open(FILE *ff);

	int		GetNumberOfPointsSplineSectorBulleEje();
	void	SetNumberOfPointsSplineSectorBulleEje(int);
	void	AddSector(	double radioA,
						double radioB,
						double ang,
						double angDelta);
	void GetSector(		int id,	
						double *radioA,
						double *radioB,
						double *ang,
						double *angDelta);
	manualContourModelBullEyeSector * GetModelSector(int id);

	void	ResetSectors();
	int		GetSizeOfSectorLst();
	virtual void UpdateSpline(); // virtual
	virtual std::vector<manualBaseModel*> ExploseModel(  );



private:
	int											   _numberPointsSlineBySector;
	std::vector<manualContourModelBullEyeSector *> _lstModelBullEyeSector;

/* Borrame Eduardo
	std::vector<double>		_lstRadioA;
	std::vector<double>		_lstRadioB;
	std::vector<double>		_lstAng;
	std::vector<double>		_lstAngDelta;
*/

	virtual int		GetTypeModel();  
};

#endif // manualContourModelBullEye_h
