/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualViewBaseContour_h
#define manualViewBaseContour_h

#include "vtkRenderWindow.h"

#include "vtkRenderer.h"
#include "vtkRenderWindowInteractor.h" //extremely important with VC++ don't remove !
#include "vtkCommand.h"
#include "vtkPolyData.h"
#include "vtkCellArray.h"
#include "vtkPolyDataMapper.h"
#include "vtkInteractorObserver.h"
#include "vtkInteractorStyleImage.h"
#include <vtkKochanekSpline.h>

#include <vtkActor.h>
#include <vtkProperty.h>
#include <vtkCellArray.h>
#include <vtkRenderer.h>
#include <vtkCoordinate.h>
#include <vtkTextProperty.h>
#include <vtkTextActor.h>
#include <vtkProperty2D.h>
#include <vtkPointPicker.h>
//#include "widgets/UtilVtk3DGeometriSelection.h"
#include "UtilVtk3DGeometriSelection.h"
#include <vtkCellPicker.h> 


#include <vtkCamera.h> 
#include <vtkPolyLine.h>
#include <vtkDataSetMapper.h>
#include <vtkUnstructuredGrid.h>

#include "wxVTKRenderWindowInteractor.h"


//--

#include <vector>
#include "wxVtkBaseView.h"
#include "marTypes.h"

#include "manualViewPoint.h"
#include "manualContourModel.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


class creaMaracasVisu_EXPORT manualViewBaseContour{

//---------------------------------------------------
// PUBLIC METHODS & ATTS
//---------------------------------------------------

public:
	manualViewBaseContour();
	virtual ~manualViewBaseContour();

	virtual int GetType();
	virtual void Save(FILE *pFile);
	virtual void Open(FILE *pFile);

	void	AddPoint();
	virtual void	AddPoint( manualViewPoint * manualViewPoint );
	void	InsertPoint(int id);
	void	DeleteContour();
	void	DeletePoint(int x, int y,int z);
	virtual void	DeletePoint(int id);

	virtual void	UpdateViewPoint(int id);
	virtual void	UpdateViewPoints();

	void	SetSelected(bool selected);
	void	SetPosibleSelected(bool posibleSelected);
	bool	GetSelected();
	bool	GetPosibleSelected();
	void	DeleteSelectedPoints();
	bool	GetEditable();
	void	SetEditable( bool * condition );



	virtual int		GetIdPoint(int x, int y, int z);

	void	SelectPoint(int i,bool select);
	void	SelectLstPoints();
	void	SelectAllPoints(bool select);
	virtual int		SelectPosiblePoint(int x, int y ,int z);
	bool	SelectPosibleContour(int x, int y ,int z);
	void	SelectAllPossibleSelected(bool select);
	void	SetPointSelected(int id,bool select);
	void	SetPointPosibleSelected(int id,bool select);
	void	SetIfViewControlPoints(bool ifShow);
	bool	GetIfViewControlPoints();
	
	void	UnSelectPoint(int i);
	void	UnSelectLstPoints();
	void	UnSelectAllPoints();

	void	SetModel(manualBaseModel *manContModel);
	void	SetWxVtkBaseView(wxVtkBaseView *wxvtkbaseview);

	virtual void	Refresh();
	int		GetNumberOfPoints();						// ??? 
	//int		GetNumberOfPointsSpline();				//JSTG 25-02-08 In ContourModel is the same method 
	//void	SetNumberOfPointsSpline(int size);			//JSTG 25-02-08 In ContourModel is the same method 

	void	CreateNewContour();
	double* GetVectorPointsXManualContour();
	double* GetVectorPointsYManualContour();
	double* GetVectorPointsZManualContour();

	virtual bool	ifTouchContour(int x,int y, int z);
	void	UpdateColorActor();

	void	SetRange(double range);
	double		GetRange();
	void	SetZ(int z);
	int		GetZ();

	wxVtkBaseView *GetWxVtkBaseView();

	virtual void InitMove(int x, int y, int z);
	virtual void MoveContour(int x, int y, int z);
	virtual void MoveContour(int horizontalUnits, int verticalUnits );
	virtual void GetMinMax( double &minX,double &minY, double &minZ, double &maxX, double &maxY, double &maxZ );
	virtual void TransfromCoordViewWorld(double &X, double &Y, double &Z, int type=2);

	void	ClearContour();
	virtual void	ClearPoint(int id);

	void	SetVisible(bool ok);
	void	SetShowText(bool ok);

	void	GetSpacing(double spc[3]);
	void	SetSpacing(double spc[3]);

	void	SetColorNormalContour(double r, double g, double b);
	void	GetColorNormalContour(double &r, double &g, double &b);
	void	SetColorEditContour(double r, double g, double b);
	void	GetColorEditContour(double &r, double &g, double &b);
	void	SetColorSelectContour(double r, double g, double b);
	void	GetColorSelectContour(double &r, double &g, double &b);
	
	//Addinging and removing from visualization specific actors included in the viewer contour
	void	AddCompleteContourActor( bool ifControlPoints = false);
	void	RemoveCompleteContourActor();
	virtual void	AddSplineActor();
	virtual void	RemoveSplineActor();
	virtual void	AddControlPoints();
	virtual void	RemoveControlPoints();	
	void	AddTextActor();
	void	RemoveTextActor();
	void InitTextActor();

	virtual manualViewBaseContour * Clone();
			void					CopyAttributesTo( manualViewBaseContour *cloneObject );
	virtual void					RefreshContour();
			void					SetWidthLine(double width);
			double					GetWidthLine();

	virtual void			ConstructVTKObjects();

//---------------------------------------------------
// PRIVATE METHODS & ATTS
//---------------------------------------------------

private:

	vtkPolyData						*_pd;
	vtkActor						*_contourVtkActor;
	vtkPolyDataMapper				*_bboxMapper;

	void			DeleteVtkObjects();
	

//---------------------------------------------------
// PROTECTED METHODS & ATTS
//---------------------------------------------------

protected:

	double					_range;

	double					_coulorEdit_r;
	double					_coulorEdit_g;
	double					_coulorEdit_b;
	double					_coulorNormal_r;
	double					_coulorNormal_g;
	double					_coulorNormal_b;
	double					_coulorSelection_r;
	double					_coulorSelection_g;
	double					_coulorSelection_b;
	double					_widthline;

	//
	// Reference to VTKBaseView
	//
	wxVtkBaseView				*_wxvtkbaseview;

	//
	// Is the contour selected
	//
	bool 					_selected;
	bool					*_editable;
	bool					_posibleSelected;
	bool					_viewControlPoints;

	// text
	bool					_show_text;
	int					_id_viewPoint_for_text;
	vtkTextActor				*_textActor;
	vtkTextActor				*_textActor2;

	//
	// Contour model
	//
	manualBaseModel				*_manContModel;

	vtkPoints				*_pts;
// JSTG 25-02-08 --------------------------------------------
	int					_sizePointsContour;
//-----------------------------------------------------------

	//
	// Control points list
	//
	std::vector<manualViewPoint*>		_lstViewPoints;

	//
	// Spacing
	//
	double					_spc[3];

	virtual void	RefreshText();

};


#endif // manualViewBaseContour_h
