/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualViewPoints_h
#define manualViewPoints_h

#include "manualViewBaseContour.h"
#include "manualViewPoint.h"
#include <vector>


// --------------------------------------------------------------------------------------------
// Class that includes the functionality to manage some selected points like a new contour
// @author RaC 09-09
class creaMaracasVisu_EXPORT manualViewPoints: public manualViewBaseContour
{
	
//---------------------------------------------------
// PUBLIC METHODS & ATTS
//---------------------------------------------------
public:
	//
	// Class Constructor
	//
	manualViewPoints();

	//
	// Method to copy all attributes to the clone object references by parameter
	// @param *cloneObject - manualViewPoints Clone object
	///
	void CopyAttributesTo( manualViewPoints *cloneObject );

	//---------------------------------------------------
	// PUBLIC & VIRTUAL METHODS & ATTS
	//---------------------------------------------------

	///
	// Class Destructor. Delete all elements in points copy list
	///
	virtual ~manualViewPoints();

	//
	// Method to clone a manualViewPoints object
	//
	virtual manualViewPoints * Clone();

	//
	// Returns the contour type
	// Points Contour type := 7
	// @return type - int	
	//
	virtual int GetType();

	//
	// Returns true if the point with the (x,y,z) window coordinates touch the contour
	// @param x - int
	// @param y - int
	// @param z - int
	// @return true if touch contour, false otherwise
	//
	virtual bool ifTouchContour(int x,int y, int z);

	//
	// Refresh control points with the specified color, calls the RefreshContour method 
	// and render the contour
	//
	virtual void Refresh();

	//
	// Refresh contour. In this case, it synchronizes the copy list with the control points list in order
	// to paint the point actors in the position assigned in the model points list
	//
	virtual void RefreshContour();

	//
	// Removes actor of the contour points, but no the control points.
	//
	virtual void RemoveSplineActor();

	//
	// Adds actor of the contour points, but no the control points.
	//
	virtual void AddSplineActor();

	//
	// Constructs VTKObjects. Only initializes text actor
	//
	virtual void ConstructVTKObjects();

	//
	// To move all the contour
	//
	//virtual void MoveContour(int x, int y, int z);

//---------------------------------------------------
// PRIVATE METHODS & ATTS
//---------------------------------------------------
private:

	//
	// Copy of the control points list. These are the points which are painted when the
	// contour is not selected
	//
	std::vector<manualViewPoint*>	_copyViewPoints;
	
};

#endif // manualViewPoints_h
