/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marParameters.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:16:12 $
  Version:   $Revision: 1.5 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __MAR__KERNEL__PARAMETERS__HXX__
#define __MAR__KERNEL__PARAMETERS__HXX__

#include "marTypes.h"
#include <wx/arrstr.h>
#include <wx/list.h>
#include <fstream>
//using namespace std;

/** /def marParameters
 *  \brief Parameters class definition.
 */
class creaMaracasVisu_EXPORT marParameters
{
    public:

    /** /def Enumerations
     *  Some mnemonic enumerations for indexes or
     *  behaviour types.
     */
    enum VoxelTypes
    {
	    VOX_TYPE_MINIMUM = 0x01,
	    VOX_TYPE_NORMAL  = 0x02

    };
    enum AlgorithmTypes
    {
	    ISOCONTOURS = 1,
	    SNAKE       = 2,
	    DERICHE     = 3

    };
    enum QuantificationTypes
    {
	    TYPE_AREA                    = 0x01,
	    TYPE_PERIMETER               = 0x02,
	    TYPE_DIAMETER_FROM_AREA      = 0x04,
	    TYPE_DIAMETER_FROM_PERIMETER = 0x08,
	    TYPE_MINIMUM_DIAMETER        = 0x10,
	    TYPE_MAXIMUM_DIAMETER        = 0x20,
	    TYPE_AVERAGE_DIAMETER        = 0x40

    };
    enum BoolParamIndexes
    {
// PS -> 	    e_debug_window_visible = 0  ,
// PS -> 	    e_debug_console_visible     ,
// PS -> 	    e_calculate_mip_default     ,
// PS -> 	    e_choose_all_slices_default ,
	    e_debug_isocontour          ,
	    e_debug_diameters           ,
	    e_debug_fill_area           ,
	    e_invest_slice_order        ,
// PS -> 	    e_show_cell                 ,
// PS -> 	    e_show_int_cell             ,
		e_bool_cont
    };
    enum DoubleParamIndexes
    {
	    e_gravity_distance = 0          ,
	    e_axis_discret_step             ,
	    e_distance_to_maximum_intensity ,
	    e_cell_coeficient               ,
	    e_flexion_coeficient            ,
	    e_tension_coeficient            ,
	    e_voxel_x_dimension             ,
	    e_voxel_y_dimension             ,
	    e_voxel_z_dimension             ,
	    e_scale                         ,
// PS -> 	    e_sampling                      ,
	    e_threshold_isocontour          ,
	    e_threshold_snake_isocontour    ,
	    e_sigma                         ,
        e_RescaleIntercept              ,
        e_RescaleSlope                  ,
// PS -> 	    e_gradient_coeficient           ,
// PS -> 	    e_extern_coeficient             ,
// PS -> 	    e_ballon_coeficient             ,
// PS -> 	    e_back_color_3D_r               ,
// PS -> 	    e_back_color_3D_g               ,
// PS -> 	    e_back_color_3D_b               ,
// PS -> 	    e_axis_color_r                  ,
// PS -> 	    e_axis_color_g                  ,
// PS -> 	    e_axis_color_b                  ,
	    e_double_cont
    };
    enum IntParamIndexes
    {
	    e_roi_dimension = 0                     ,
	    e_step                                  ,
	    e_step_coeficient                       ,
	    e_mass_power                            ,
	    e_algorithm_type                        ,
	    e_mask_size                             ,
	    e_number_of_points_for_snake            ,
	    e_quantification_type                   ,
	    e_stenosis_type                         ,
// PS -> 	    e_number_of_iterations_snake_isocontour ,
// PS -> 	    e_number_of_iterations_snake_deriche    ,
	    e_voxel_type                            ,
// PS -> 	    e_coef_cell_max_int                     ,
	    e_int_cont
    };

//EED
	enum StringParamIndexes
     {
 	    e_installation_directory = 0 ,
 	    e_dicom_images_directory    ,
 	    e_string_cont
     };

    public:

    /** Default constructor.
     */
    marParameters( ) { reset( );  };

    /** Default destructor.
     */
    ~marParameters( ) {}

    /** Default analyzers & modificators.
     *
     *  These methods use an index i, which should be one defined on
     *  correspondant type enum. For example, if you want to get the
     *  installation directory parameter you should write:
     *
     *  marParameters* myParams = new marParameters( );
     *  std::string myDir = myParams->
     *                         getStringParam(
     *                              marParameters::e_installation_directory );
     */
    bool   getBoolParam( int i )            { return( _boolValues[ i ] );   };
    double getDoubleParam( int i )          { return( _doubleValues[ i ] ); };
    int    getIntParam( int i )             { return( _intValues[ i ] );    };

//EED
     wxString& getStringParam( int i )       { return( _stringValues[ i ] );};

    void   setBoolParam( int i, bool p )     { _boolValues[ i ] = p;	    };
    void   setDoubleParam( int i, double p ) { _doubleValues[ i ] = p;      };
    void   setIntParam( int i, int p )       { _intValues[ i ] = p;         };

//EED
     void setStringParam( int i, const wxString& p ) { _stringValues[ i ] = p;	};

    /** Special analizers & modifiers
     *  (in marKernel context, of course).
     */
    double	getVoxelSize( );
    double	getDimIma( );
    int		getSizeIma( );
    double	getImaRatio( );
    float	getRescaleSlope();
    float	getRescaleIntercept();
	bool	getInvestSliceOrder();

    void	setROIStep( double width );
    void	setRescaleSlope(float slope);
    void	setRescaleIntercept(float intercept);


    /** Copy.
     */
    void   copyFrom( const marParameters& from );

    /** Persistence methods.
     */
    void reset( );
    bool save( std::ofstream& os );
    bool load( std::ifstream& is );
    bool save( wxString& nw );
    bool load( wxString& nr );

    wxArrayString getRelationalArray( );
    void setRelationalArray( wxArrayString& arr );

	//MAZV - Added for CT compatibility
	int getContourThresh();
	double getStandardDeviation();
	double getRadius();
	int	getLumenPercentage();
	int getCalcPercentage();

	void setContourThresh( int thresh );
	void setStandardDeviation( double dev );
	void setRadius( double rad );
	void setLumenPercentage(int percentage);
	void setCalcPercentage(int percentage);
	//MAZV - End of addition


  private:

    bool   _boolValues[ ( int )e_bool_cont ];
    double _doubleValues[ ( int )e_double_cont ];
    int   _intValues[ ( int )e_int_cont ];

// EED
	wxString _stringValues[ ( int )e_string_cont ];

	//MAZV Added fot CT compatibility
	int	_contourThresh;
	double	_standardDeviation;
	double	_radius;
	int _lumenPercentage;
	int _calcPercentage;
	//MAZV - End of addition

};


	
	

#endif // __MAR__KERNEL__PARAMETERS__HXX__

// eof - marParameters.h
