/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

////////////////////////////////////////////////////////////////////////////////
// matrix.h
// Creation : 20/01/2000
// Author   : Leonardo FLOREZ VALENCIA
//               l-florez@uniandes.edu.co
//               lflorez@creatis.insa-lyon.fr
// Copyright (C) 2000-2002 Leonardo FLOREZ VALENCIA
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
////////////////////////////////////////////////////////////////////////////////

#ifndef GTMLIB__MATH__MATHDEFS__HXX
#define GTMLIB__MATH__MATHDEFS__HXX

#include <math.h>

/// PI constant.
#define GTM_PI  3.14159265359
/// 2 * PI constant.
#define GTM_PI2 6.28318530717
/// ln1 constant.
#define GTM_NE  2.71828182846

/// Minimum.
#define GTM_MIN( a, b ) ( ( ( a ) < ( b ) )? ( a ): ( b ) )
/// Maximum.
#define GTM_MAX( a, b ) ( ( ( a ) > ( b ) )? ( a ): ( b ) )
#define GTM_POW2( a ) ( ( a ) * ( a ) )

// Useful typedefs. // Useless now // JPR
/*
typedef unsigned char  uchar;
typedef unsigned short ushort;
typedef unsigned int   uint;
*/

namespace gtm
{
    /** Rounds a double number.
     *
     *  @param n Number.
     */
    inline
    double round( double n )
    {
	double tmp;
	tmp = floor( n );
	if ( ( n - tmp ) < 0.5 )
	    return( tmp );
	else
	    return( ceil( n ) );
    }
}

#endif // GTMLIB__MATH__MATHDEFS__HXX

// EOF - mathdefs.h
