/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __pFIGURE__
#define __pFIGURE__

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

/** @file pFigure.h */
class pFigure :public  wxObject{

public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	/**
	* Create a figure with edges_n edges
	* @param edges_n The number of edges of the new figure
	* @param _w The width to set
	* @param _h The height to set
	* @param _orientation The figure orientation to set
	* @param bar_orientation The figure orientation to set
	*/
	pFigure(int edges_n, int _w, int _h,int _orientation, bool bar_orientation);
	~pFigure();

	//------------------------------------------------------------------------------------------------------------
	// Methods
	//------------------------------------------------------------------------------------------------------------

	/**
	* Gets the number of edges of the figure
	* @retval edges Number of edges in the figure
	*/
	int getNumberEdges();

	/**
	* Sets the vertex points of the figure
	* @param edges Number of edges in the figure to set
	*/
	void setNumberEdges(int n_edges);
	
	/**
	* Gets the vertex points of the figure
	* @param wxPoint The vector to get the points
	* @retval points Vertex points distribution in the figure
	*/
	void getVertexPoints(wxPoint thePoints[]);

	/**
	* Sets the vertex points of the figure
	* @param edges Vertex points distribution in the figure to set
	*/
	void setVertexPoints(wxPoint * n_points);

	/*
	* Sets the heigth of the figure
	* @param _h The heigth to set
	*/
	void setHeigth(int _h);

	/*
	* Gets the heigth of the figure
	* @retval heigth The heigth of the figure
	*/
	int getHeigth();

	/*
	* Sets the width of the figure
	* @param _w The width to set
	*/
	void setWidth(int _w);

	/*
	* Gets the width of the figure
	* @retval width The width of the figure
	*/
	int getWidth();

	/*
	* Indicates if a pixel point is inside the figure
	* @param xFig_PixelPoint The known reference point inside the figure
	* @param xPixel The x-pixel coord asking for
	* @retval Returns true if the point is inside
	*/
	bool isPointInside(int xFig_PixelPoint, int xPixel);

	/*
	* Sets the bar orientation 
	* @ bar_orientation The orientation to set (true for horizontal, false for vertical)
	*/
	void setBarOrientation(bool bar_orientation);

	/*
	* Sets the bar orientation used for triangles
	* @ bar_orientation The orientation to set (LEFT = -4, RIGHT = -6, UP = -8, DOWN = -2)
	*/
	void setFigureOrientation(int fig_orientation);
	
	//------------------------------------------------------------------------------------------------------------
	// Constants
	//------------------------------------------------------------------------------------------------------------
	
	enum
	{
		TRIANGLE = 3,
		RECTANGLE = 4,
		LEFT = -4,
		RIGHT = -6,
		UP = -8,
		DOWN = -2,
	};

private:

	//------------------------------------------------------------------------------------------------------------
	// Attributes
	//------------------------------------------------------------------------------------------------------------

	/*
	* Represents the heigth of the figure
	*/
	int heigth;

	/*
	* Represents the width of the figure
	*/
	int width;

	/*
	* Represents the edges of the figure
	*/
	int edges;

	/**
	* Represents the orientation UP, DOWN, LEFT, RIGTH of the figure
	*/
	int orientation;

	/*
	* Is the bar orientation (true for HORIZONTAL, false VERTICAL)
	*/
	bool barOrientation;

	/*
	* Represents the vertex points distribution of the figure in pixels scale
	*/
	wxPoint *v_points;

DECLARE_CLASS(pColorBar)

};
#endif


