/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __pFunctionPoint_h__
#define __pFunctionPoint_h__

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//----------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Class definition
//----------------------------------------------------------------------------

class pFunctionPoint : public wxObject {

	//----------------------------------------------------------------------------
	// Methods definition
	//----------------------------------------------------------------------------
public:
	/**
	* Create a point of the function.
	* @param x The x value
	* @param y The y value
	*/
	pFunctionPoint(int  x , int  y ) ;

	/*
	* Returns the x-value of the point
	* @ realX
	*/
	int getRealX ();
	/**
	* Returns the y-value of the point
	* @ realY
	*/
	int getRealY ();
	/**
	* Sets the x-value of the point
	* @param x
	*/
	void setRealX(int x)
	{
		realX=x;
	}
	/**
	* Sets the y-value of the point
	* @param y
	*/	
	void setRealY(int y)
	{
		realY=y;
	}
	/*
	* Sets the state of having an asigned color
	*/
	void setHasColor (bool hasColor);
	/*
	* Indicates if the point has an asigned color for the level 
	*/
	bool getHasColorForLevel();


	//----------------------------------------------------------------------------
	// Attributes declration
	//----------------------------------------------------------------------------

private:
	/*
	* The x-value of the point
	*/
	int realX;
	/*
	* The y-value of the point
	*/          
	int realY;
	/*
	*  Indicates if the point has an asigned color for the level
	*/
	bool hasColorForLevel;

	DECLARE_CLASS (pFunctionPoint)
};

#endif


