/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file structBCSettings.h
 * @brief Contains BCSettingsStruct structure.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef STRUCTBCSETTINGS_H_
#define STRUCTBCSETTINGS_H_

#include "system.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::model>
	 *	@brief Contains the implementation of the model in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace model
	{
		/*! @struct <BCSettingsStruct> structBCSettings.h "structBCSettings.h"
		 *	@brief This is the Button Container Settings structure.
		 */
		struct BCSettingsStruct
		{
				StringType groupName; 			//! <The name of the group of buttons.
				StringType buttonName; 			//! <The name of the button.
				StringType iconpath; 			//! <The iconPath of the button.
				BitmapType icon; 			//! <The iconPath of the button.
				StringType buttonDescription; 		//! <The description of the button.
				FunctionEventType eventFunction; //! <The event associated to the button.

		};
	} //ecapseman
} //ecapseman
#endif //STRUCTBCSETTINGS_H_
