/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file system.h
 * @brief Contains a system typedefs used to reuse code.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef SYSTEM_H_
#define SYSTEM_H_

#include <list>
#include <map>
#include <iostream>
#include <exception>
#include <string>
#include "functor.h"


namespace creaButtonContainer
{

	//using namespace view;

	// ----------------------------------------------------------------------------------
	/*!	@typedef std::string* StringType;
	 *	@brief Defines the StringType type.
	 */
	typedef std::string StringType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef std::string* BitmapType;
	 *	@brief Defines the BitmapType type.
	 */
	typedef wxBitmap BitmapType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef model::TFunctor* FunctionEventType;
	 *	@brief Defines the FunctionEventType type.
	 */
	typedef model::TFunctor* FunctionEventType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef creaButtonContainer::view::Button Button;
	 *	@brief Defines the ActionButton type.
	 *	First is the button description, Second FunctionEventType
	 */
	typedef std::pair< StringType, FunctionEventType > ButtonAction;
	
	// ----------------------------------------------------------------------------------
	/*!	@typedef std::pair< std::string, BitmapType > ButtonInfo;
	 *	@brief Defines the ButtonInfo type.
	 *	First is the ButtonName and Second is the IconPath
	 */
	typedef std::pair< StringType, BitmapType > ButtonInfo;

	// ----------------------------------------------------------------------------------
	/*!	@typedef std::pair< ButtonInfo*, ActionButton* > ButtonPair;
	 *	@brief Defines the ButtonPair type.
	 */
	typedef std::pair< ButtonInfo*, ButtonAction* > ButtonPair;
	// ----------------------------------------------------------------------------------
	/*!	@typedef std::list< std::string > KeyMapList;
	 *	@brief Defines the KeyMapList type.
	 */
	typedef std::list< StringType > KeyMapList;
	
	// ----------------------------------------------------------------------------------
	/*!	@typedef std::list< ButtonPair* > ButtonList;
	 *	@brief Defines the ButtonList type.
	 */
	typedef std::list< ButtonPair* > ButtonList;
	
	// ----------------------------------------------------------------------------------
	/*!	@typedef std::map< std::string, ButtonList > ButtonGroupMap;
	 *	@brief Defines the ButtonGroupMap type.
	 */
	typedef std::map< StringType, ButtonList > ButtonGroupMap;


// ----------------------------------------------------------------------------------
}
#endif /* SYSTEM_H_ */
