/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef VTKIMAGEVIEWER2_XYZ_H_
#define VTKIMAGEVIEWER2_XYZ_H_


//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------
#include "marTypes.h"
#include "vtkImageViewer2.h"
#include "vtkImageMapToWindowLevelColors.h"
#include "vtkColorTransferFunction.h"

class  creaMaracasVisu_EXPORT vtkImageViewer2_XYZ{
public:
	vtkImageViewer2_XYZ();
	~vtkImageViewer2_XYZ();

	void			SetExtentDimension(int x1,int x2, int y1,int y2, int z1,int z2);
	void			SetXSlice(int slice);
	void			SetYSlice(int slice);
	void			SetZSlice(int slice);
	int				GetXSlice();
	int				GetYSlice();
	int				GetZSlice();
	

	void setColorTransferFunction(vtkColorTransferFunction* colortable);

	vtkImageViewer2 *GetVtkImageViewer2();
private:
	int	_x1,_x2,_y1,_y2,_z1,_z2;
	vtkImageViewer2 *_vtkimageviewer2;
	vtkColorTransferFunction* _colortable;
	
	
protected:	
	
};


#endif /*VTKIMAGEVIEWER2_XYZ_H_*/
