/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef VTKPLANE2DVIEW_H_
#define VTKPLANE2DVIEW_H_

#include "vtkInteractorStylePlane2D.h"
#include "vtkInfoTextImageInteractorPlane2D.h"
#include "vtkInfoTextImage.h"

#include "wxMPRBaseData.h"
#include "wxVtk2DBaseView.h"

#include "vtkTransform.h"
#include "vtkImageChangeInformation.h"
#include "vtkStructuredPoints.h"
#include "vtkPlaneSource.h"
#include "vtkProbeFilter.h"
#include "vtkPolyDataMapper.h"

class vtkPlane2DView : public wxVtk2DBaseView
{
public:
	vtkPlane2DView(wxWindow *parent);
	~vtkPlane2DView();
	void			Configure();
	void			ExtractPlane();
	int				GetImgSize();
	void			SetImgSize( int imgSize );

	void			RotationStart();
	void			RotationDrag(double vx, double vy,  bool ok_v, bool ok_ang);

	virtual int		GetActualSlice(); 
	virtual void	SetActualSlice(int slice);

	virtual void	Refresh( );

	vtkMPRBaseData				*GetVtkmprbasedata();
	vtkInteractorStylePlane2D	*GetInteractorstyleplane2D();

	void			SetActive(bool active);
	void			SetVisibleLine(bool ok);

	void			TransfromCoordViewWorld2(double &X, double &Y, double &Z);

	int				GetMipWidth();
	void			SetMipWidth(int value);
	bool			GetMipVisualization();
	void			SetMipVisualization(bool ok);

	void			ResetBack();

private:
	bool			_active;
	int				_mip_width;
	bool			_mip_visualization;

	double			_backX;
	double			_backY;
	double			_backZ;
	double			_backOrient[4];

	double			_ang;
	double			_vxb;
	double			_vyb;
	double			_n[3];   // Normal

	double			_cx;
	double			_cy;
	double			_cz;

	int				_sizeIma;

	vtkImageData *	_imageResult;

	// Horizontal line
	vtkPoints							*_pts;
	vtkActor							*_lineActor;
	vtkPolyDataMapper					*_lineMapper;
    vtkPolyData							*_pd;

    vtkProbeFilter						*_3Dslices;
	vtkPlaneSource						*_pSource;
	vtkStructuredPoints					*_stPoints;
    vtkImageChangeInformation			*_change;
	vtkTransform						*_transform1; 
	vtkTransform						*_transform2; 

	vtkInteractorStylePlane2D			*_interactorstyleplane2D;

	vtkInfoTextImage					*_vtkInfoTextImage;
	vtkInfoTextImageInteractorPlane2D	*_vtkInfoTextImageInteractorPlane2D;


	void SetPSource(int sizeIma);
	void HorizontalLine();
	void ResetPlane();
	void Extract_One_PlaneVTK();
	void Extract_MIP_PlaneVTK();

protected:
};

#endif /*VTKPLANE2DVIEW_H_*/
