/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMPRWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.13 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MPR__WIDGET__HXX__
#define __WX__MPR__WIDGET__HXX__

#include "marTypes.h"
#include <vector>

#include <vtkObjectBase.h>
#include <vtkCommand.h>
#include <vtkActor.h>
#include <vtkPoints.h>
#include <vtkPolyData.h>
#include <vtkPolyDataMapper.h>
#include <vtkProbeFilter.h>
#include <vtkPlaneSource.h> 
#include <vtkImageChangeInformation.h>
#include <vtkStructuredPoints.h> 
#include <vtkTransform.h> 
#include <vtkImageViewer2.h> 
#include <vtkBoxWidget.h>
#include <vtkPointWidget.h>
#include <vtkPlaneWidget.h>

#include <vtkCubeSource.h>
#include <vtkCylinderSource.h>
#include <vtkSphereSource.h>
#include <vtkProperty2D.h>
#include <vtkTextProperty.h>
#include <vtkXYPlotActor.h>

#include "wxMPRBaseData.h"
#include "wxVtkBaseView.h"

#include <wx/notebook.h>
#include <wx/listbox.h>
#include <wx/tglbtn.h>
#include <wx/splitter.h>
#include "marTypes.h"
#include "vtkInteractorStyleSphere.h"
#include "idAlBeRa.h"

#include "wxVtkMPR3DView.h"
#include "wxVtkMPR2DView.h"
#include "vtkPlane2DView.h"
#include "wxSphereView.h"
#include "wxVtkClipping3DView.h"
#include "wxPanelCuttingImageData.h"
#include "wxWidgetMesure2D_Plane_in_MPR.h"

#include "wxVtk3DBaseView.h"

//class wxMPRWidget;
//class vtkInteractorStylePlane2D;
//class vtkInfoTextImageInteractorPlane2D;
//class vtkInteractorStyleMPRView;
//class wxVtkMPR3DView;
//class wxVtkClipping3DView;

class creaMaracasVisu_EXPORT wxMPRWidget : public wxPanel
{
public:
    wxMPRWidget(wxWindow* parent,marImageData *marimageData = NULL,double voxelSize = -1);
	~wxMPRWidget( );
	void ConfigureVTK();

	virtual void OnRefreshView(wxCommandEvent & event);
	void OnDClickLeft(wxCommandEvent & event);

	void OnPageAChanged(wxNotebookEvent & event);
	void OnPageBChanged(wxNotebookEvent & event);

	vtkMPRBaseData	*GetVtkMPRBaseData();
	vtkPlane2DView	*GetVtkPlane2DView();
	
	//returns the 3d view of the widget
	wxVtkMPR3DView  *GetWxvtkmpr3Dview_BB();

	void	RefreshView(bool firsttime=false);

	wxVtkBaseView *GetWxVtkBaseView(int page, int id);

	//returns the 2d view of the specific direction (0|1|2)
	wxVtkMPR2DView *GetWxvtkMPR2Dview(int direction);

	void setImageData(vtkImageData * img, double voxelsize);

private:
	double					_voxelSize;
	marImageData			*_marImageData; 
	vtkMPRBaseData			*_vtkmprbasedata; 
	wxVtkMPR2DView			*_vtkmpr2Dview[3]; 
	vtkPlane2DView			*_vtkplane2Dview;
	wxSphereView			*_wxsphereview;
	wxVtkMPR2DView			*_vtkmpr2Dview_B[3]; 
	vtkPlane2DView			*_vtkplane2Dview_B;
	wxSphereView			*_wxsphereview_B;

	wxVtk3DBaseView			*_wxvtk3Dbaseview_MPRClipping3D;
	wxVtkMPR3DView			*_wxvtkmpr3Dview;
	wxVtkClipping3DView		*_wxvtkclipping3Dview;

	wxVtk3DBaseView			*_wxvtk3Dbaseview_MPR3D_B;
	wxVtkMPR3DView			*_wxvtkmpr3Dview_B;

	wxVtk3DBaseView			*_wxvtk3Dbaseview_Clipping3D_BB;
	wxVtkMPR3DView			*_wxvtkmpr3Dview_BB;
	wxVtkClipping3DView		*_wxvtkclipping3Dview_BB;

	int						_refreshAPage;
	int						_refreshBPage;


	wxFrame					*_framePanelCutting;
	wxCheckBox				*_btnCutImageData;
	wxPanelCuttingImageData	*_panelCutting;

	wxWidgetMesure2D_Plane_in_MPR	*_widgetMesure;
	wxWidgetMesure2D_Plane_in_MPR	*_widgetMesure_B;

	wxPanel	*CreateControlPanel(wxWindow *parent);
	wxPanel	*CreateMPRPanel(wxWindow *parent, vtkMPRBaseData *vtkmprbasedata);
	wxPanel *CreateMPRPanel4View(wxWindow *parent, vtkMPRBaseData *vtkmprbasedata);
	wxPanel *CreateView(int type,wxWindow *parent, vtkMPRBaseData *vtkmprbasedata);

	void 	OnCutImagaData( wxCommandEvent &event);

	DECLARE_EVENT_TABLE( );
};

#endif // __WX__MPR__WIDGET__HXX__



// EOF - wxMPRWidget.h
