/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef _WX_MANUAL_PAINT_PANEL_H_
#define _WX_MANUAL_PAINT_PANEL_H_

#include "ManualPaintPanel.h"

#include "mBarRange.h" //DFCH
#include "creaWx.h" //DFCH
#include <wx/wx.h>
#include <wx/panel.h>
#include <wx/spinctrl.h>
#include <wx/string.h>

class wxManualPaintPanel: public wxPanel, public ManualPaintPanel
{
public:
	wxManualPaintPanel( wxWindow * parent );
	virtual ~wxManualPaintPanel( );
	//Panel Config
	void ConfigureActiveCBButton();
	void ConfigureBrushToolRadioButton( );
	void Configure2D3DRadioButton( );
	void ConfigureBrushFormRadioButton( );
	void ConfigureRangeBar( );
	void ConfigureGrayLevelSld( );
	void ConfigureBrushSizeSld( );
	void ConfigureDistanceFillSld( );
	void ConfigureTolFillSld( );
	void ConfigureEditButtons( );
	//Events
	void ConnectComponents( ); //DFCH
	void OnActive(wxCommandEvent& event);
	void OnBrushSize( wxScrollEvent& event );
	void OnSldGrayLevel( wxScrollEvent& event );
	void OnCtrTxtGrayLevel( wxCommandEvent &event );
	void On2D3D( wxCommandEvent &event );
	void OnBrushForm( wxCommandEvent &event );
	void OnBrushTool( wxCommandEvent &event );
	void OnCopy( wxCommandEvent &event );
	void OnUndo( wxCommandEvent &event );
	void OnRedo( wxCommandEvent &event );
	void DisableControls( );
	void OnSldToleranceFill( wxScrollEvent& event );
	void OnCtrTxtToleranceFill( wxCommandEvent &event );
	void OnSldDistanceFill( wxScrollEvent& event );
	void OnCtrTxtDistanceFill( wxCommandEvent &event );
	void OnCtrBrushSize( wxCommandEvent &event );
	//This method changes the min/max in the Selected Range Widget
	//--------------------------------------------------------------------------------------------------------------------------------
	// Min-Max Barrange received events
	//--------------------------------------------------------------------------------------------------------------------------------
	void onBarrange( wxCommandEvent& event );
	void onActualChange_Bar( wxCommandEvent& event );
	void onStartChange_Bar( wxCommandEvent& event );
	void onEndChange_Bar( wxCommandEvent& event );
	void onSelectionEnd( wxCommandEvent& event );
	void onMovedBar( wxCommandEvent& event );

private:
	wxCheckBox 	*_activeCB;
	wxStaticText 	*_txtBrushSize;
	wxSlider 	*_sldBrushSize;
	wxSpinCtrl 	*_BrushSizeCtrl;

	wxStaticText 	*_txtGrayLevel;
	wxSlider 	*_sldGrayLevel;
	wxSpinCtrl 	*_graylevelCtrl;
	wxRadioBox 	*_rbBrushForm;
	wxRadioBox 	*_rb2D3D;
	wxRadioBox 	*_rbBrushTool;

	wxStaticText 	*_txtToleranceFill;
	wxSlider 	*_sldToleranceFill;
	wxSpinCtrl 	*_tolerancefillCtrl;

	wxStaticText 	*_txtDistanceFill;
	wxSlider 	*_sldDistanceFill;
	wxSpinCtrl 	*_distancefillCtrl;

	mBarRange 	*_mBarSlices; //DFCH
	wxButton 	*_btnCopy; //DFCH
	wxButton 	*_btnUndo; //DFCH
	wxButton 	*_btnRedo; //DFCH

	wxFlexGridSizer *_buttonsSizer; //DFCH
	wxFlexGridSizer *_FillSizer; //DFCH
	wxFlexGridSizer *_gConfigSizer; //DFCH
	wxFlexGridSizer *_brushSizer; //DFCH

protected:

};

#endif // _WX_MANUAL_PAINT_PANEL_H_
