/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxManualTree_MPRWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.4 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MANUAL__TREE__MPR__WIDGET__HXX__
#define __WX__MANUAL__TREE__MPR__WIDGET__HXX__

/*
#include <vector>

#include <vtkObjectBase.h>
#include <vtkCommand.h>
#include <vtkActor.h>
#include <vtkPoints.h>
#include <vtkPolyData.h>
#include <vtkPolyDataMapper.h>
#include <vtkProbeFilter.h>
#include <vtkPlaneSource.h> 
#include <vtkImageChangeInformation.h>
#include <vtkStructuredPoints.h> 
#include <vtkTransform.h> 
#include <vtkImageViewer2.h> 
#include <vtkBoxWidget.h>
*/
	     
/*
#include "kernel/marInterface.h"

#include "wxMPRBaseData.h"
#include "wxVtkBaseView.h"
*/

#include "wxMPRWidget.h"
#include "wxMPRWidget2.h"
#include "manualViewPerpPlaneContour.h"
#include "manualContourModel.h"
#include "manualContour3VControler.h"
#include "manualView3VContour.h"
#include "manualContour3V3DControler.h"
#include "manualView3DContour.h"
#include "manualContourPerpPlaneControler.h"
#include "manualViewPerpPlaneContour.h"

#include <wx/notebook.h>

#include "wxVtk3DBaseView.h"

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------


class wxManualTree_MPRWidget : public wxPanel
{
public:
    wxManualTree_MPRWidget(wxWindow* parent,marImageData *marimageData,double voxelSize);
	~wxManualTree_MPRWidget( );

	void ConfigureVTK();

	void RefreshView();
	void OnRefreshView(wxCommandEvent & event);


	vtkMPRBaseData		*GetVtkMPRBaseData();
	vtkPlane2DView		*GetVtkPlane2DView();

	manualContourModel	*GetManualContourModel();


private:
	double								_voxelSize;
	marImageData						*_marimageData; 
	wxMPRWidget2						*_MPRWidget2;

	//
	manualContour3VControler			*_manContourControl_0;
	manualView3VContour					*_mViewContour_0;

	manualContour3VControler			*_manContourControl_1;
	manualView3VContour					*_mViewContour_1;

	manualContour3VControler			*_manContourControl_2;
	manualContourModel					*_mContourModel_2;
	manualView3VContour					*_mViewContour_2;

	manualContour3V3DControler			*_manContourControl_3V3D;
	manualView3DContour					*_mViewContour_3D;


	manualContourPerpPlaneControler		*_manContourControl_p;
	manualViewPerpPlaneContour			*_mViewContour_p;

	//
	wxVtk3DBaseView						*_wxvtk3Dbaseview_Clipping3D_C;
	wxVtkMPR3DView						*_wxvtkmpr3Dview_C;
	wxVtkClipping3DView					*_wxvtkclipping3Dview_C;

	wxPanel		*Create3DViewContour( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata);
	void		ConfigureContour();

	DECLARE_EVENT_TABLE( );



};




#endif // __WX__MANUAL__TREE__MPR__WIDGET__HXX__

// EOF - wxManualTree_MPRWidget.h
