/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasMultipleVolumeRendererManager.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.8 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/




#ifndef __wxMaracasMultipleVolumeRendererManagerH__
#define __wxMaracasMultipleVolumeRendererManagerH__

#include <iostream>
#include <vector>
#include <vtkMatrix4x4.h>

#include "wxMaracasMultipleVolumeRendererManagerData.h"


class wxMaracasMultipleVolumeRendererManager  {

public:
	wxMaracasMultipleVolumeRendererManager();
	~wxMaracasMultipleVolumeRendererManager();

	/**
	**	Sets the renderer to manage the prop3D from the view
	**/
	void setRenderer(vtkRenderer*  renderer);

	/**
	**	Gets the renderer to manage the prop3D from the view
	**/
	vtkRenderer* getRenderer();
	
	/**
	**	Adds a volume
	**/
	int addVolume(int idTP, vtkImageData* img, std::string dataname) throw (char*);	
	
	/**
	**	loads a prop3D from a nSTL file
	**/
	vtkProp3D* getVolume(std::string filename);

	/**
	**	loads a MHD file to convert it into an actor
	**/
	vtkImageData* getImageData(std::string filename);

	/**
	** Gets image data asotiated with the rendering manager
	**/
	vtkImageData* getImageData();

	/**
	**	adds or removes an actor depending of the bool value
	**/
	void addRemoveActor(int propid, bool addremove) throw(char*);
	
	/**
	**	Check if the variables are setted correctly
	**/
	void checkInvariant()throw(char*);

	/** 
	** Set Volume Opacity
	**/
	void setVolumeOpacity(int propid, std::vector<double> greylevel,std::vector<double> value) throw(char*);
	/**
	**	Set Volume Color
	**/
	void setVolumeColor(int volid, std::vector<double> greylevel,
									std::vector<double> red,
									std::vector<double> green,
									std::vector<double> blue)throw(char*);	

	/**
	** Given an id search the data in the vector
	**/
	wxMaracasMultipleVolumeRendererManagerData* getViewData(int id)throw(char*);

	void changeCompositeMIPFunction(int id, int function) throw (char *);
	
	/**
	** Deletes given actor
	**/
	void deleteActor(int volumeid)throw (char *);

	/**
	** Updates given volume
	**/
	void Update(int propid);
	
	vtkPiecewiseFunction* GetTransferFunction(int volumeid);
	vtkColorTransferFunction* GetColorFunction(int volumeid);
private:	
	std::vector<wxMaracasMultipleVolumeRendererManagerData*> prop3Dvect;

	vtkRenderer*  _renderer;
	vtkImageData* image;

	int _idCount;

	

	
};

#endif 
