/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef wxMaracasMultipleVolumeRendererManagerData_H_
#define wxMaracasMultipleVolumeRendererManagerData_H_

#include <vtkVolumeRayCastCompositeFunction.h>
#include <vtkPlanes.h>
#include <vtkVolumeRayCastMapper.h>
#include <vtkVolumeProperty.h>
#include <vtkVolume.h>
#include <vtkPiecewiseFunction.h>
#include <vtkColorTransferFunction.h>
#include <vtkImageData.h>
#include <vtkProp3D.h>
#include <vtkRenderer.h>
#include <vtkVolumeRayCastMIPFunction.h>

#include <vector>


class wxMaracasMultipleVolumeRendererManagerData  {

public:
	wxMaracasMultipleVolumeRendererManagerData(vtkImageData* vol, std::string dataname="");	
	~wxMaracasMultipleVolumeRendererManagerData();		
	
	/**
	**	Check if the variables are setted correctly
	**/
	void checkInvariant()throw (char *);

	/**
	** Updates volume
	**/
	void Update();
	
	/**
	**	get the prop3D 
	**/
	vtkProp3D* getProp3D();
	
	/**
	**	return the id from the daat
	**/
	int getId();
	
	/**
	**	set data id
	**/
	void setId(int propid);
	
	/**
	**	Get the filanme
	**/
    std::string getDataname();
	
	/**
	** Set the filanme
	**/
    void setDataname(std::string dataname);
	
	/**
	**	Set Volume Color
	**/
	void setVolumeColor(std::vector<double>& greylevel,
									std::vector<double>& red,
									std::vector<double>& green,
									std::vector<double>& blue);	

	/**
	**	Volume Opacity
	**/
	void setVolumeOpacity(std::vector<double> greylevel,std::vector<double> value);

	vtkPiecewiseFunction* GetTransferFunction(){
		return _tfun;
	}

	vtkColorTransferFunction* GetColorFunction(){
		return _ctfun;
	}

	void changeCompositeMIPFunction(int function) throw (char *);
	
protected:
	/**
	 * Prop 3D (data actor)
	 */
	vtkImageData* _vol;	
	/**
	 *  Dataname given by the user (ex. filename) 
	 **/
	std::string _dataname;	
	
	
private:
	
	/*
	 * id of the data
	 */
	int _id;		

	vtkVolumeRayCastCompositeFunction	*_compositeFunction;
	vtkPlanes							*_volumePlanes;
	vtkVolumeRayCastMapper				*_volumeMapper;
	vtkVolumeProperty					*_volumeProperty;
	vtkVolume							*_newvol;
	vtkPiecewiseFunction* _tfun;
	vtkColorTransferFunction* _ctfun;
	vtkVolumeRayCastMIPFunction* _MIPFunction;

	
};

#endif /*wxMaracasMultipleVolumeRendererManagerData_H_*/
