/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasSuperposition.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.5 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __wxMaracasSuperpositionH__
#define __wxMaracasSuperpositionH__

#include <vector>
#include <wx/wx.h>
#include "wx/aui/aui.h"
#include "wxMaracasSuperpositionPanel.h"
#include "vtkMetaImageReader.h"
#include "vtkImageData.h"




class creaMaracasVisu_EXPORT wxMaracasSuperposition : public wxPanel
{	

public:
	
	wxMaracasSuperposition(wxWindow* parent, std::vector<vtkImageData*> imgs);

	~wxMaracasSuperposition();

	static wxMaracasSuperposition* getInstance(wxWindow* parent, std::vector<vtkImageData*> imgs);
	
	static wxMaracasSuperposition* getInstance();
	
	wxAuiNotebook * createNotebook();

	void createPanels();

	void configurePanels();

	void changeImages(std::vector<vtkImageData*> imgs);

	std::vector<vtkImageData*> getImages( );

	
private:

	static wxMaracasSuperposition * instance;

	wxAuiManager m_mgr;
	
	wxAuiNotebook * _notebook;

	std::vector<vtkImageData*> _images;
	
	wxMaracasSuperpositionPanel * _superposition1;
	
	wxMaracasSuperpositionPanel * _superposition2;
	
	wxMaracasSuperpositionPanel * _superposition3;

    long m_notebook_style;
	
    long m_notebook_theme;
};

#endif

