/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasSurfaceRendering.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:37 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __wxMaracasSurfaceRenderingPanelH__
#define __wxMaracasSurfaceRenderingPanelH__

#include <vector>
#include <wx/wx.h>
#include "wx/aui/aui.h"
#include <iostream>
#include "marTypes.h"
#include "vtkProp3D.h"

#include "wxMaracasSurfaceRenderingManager.h"
#include "wxMaracasSurfaceRenderingPanel.h"

class  creaMaracasVisu_EXPORT  wxMaracasSurfaceRendering : public wxPanel
{

public:
    wxMaracasSurfaceRendering( wxWindow* parent, std::string path);
    ~wxMaracasSurfaceRendering( );

    static wxMaracasSurfaceRendering* getInstance(wxWindow* parent,std::string path="");

    static wxMaracasSurfaceRendering* getInstance();

    void setRenderer(vtkRenderer*  renderer);

    void setInteractor(vtkRenderWindowInteractor*  interactor);

    void changeOpacity(int propid, int value);

    void changeIsoValue(int propid, double value);

    void addRemoveActor(int propid, bool addremove);

    void addRemoveSurfaceBox(int propid, bool addremove);

    void changeColor(int propid, double red, double green, double blue);

    void addProp3D(vtkProp3D* prop3D, std::string dataname="");

    void addPropMHD(vtkImageData* imgdata, std::string dataname="");

    void loadProp3D(wxString filename, wxString dataname);

    void loadPropMHD(wxString filename, wxString dataname);

    void onLoadImageFile();

    void addSurfaceRenderingPanel(wxMaracasSurfaceRenderingPanel* surrend, std::string dataname="");

    std::string getPath();

    void deleteActor(int propid);

    bool interactorSet();

private:
    static wxMaracasSurfaceRendering* instance;

    wxMaracasSurfaceRenderingManager* surrendmanager;
	
    wxAuiManager* wxauimanager;
    
    wxToolBar* _toolb;

    std::string _path;

    void createFileChooser();
};

class ToolBarEventHandler : public wxEvtHandler{

	public:
		ToolBarEventHandler();
		~ToolBarEventHandler();

		void onLoadImageFile(wxCommandEvent& event);

	private:

		DECLARE_EVENT_TABLE()
	};

class ToolBar : public wxToolBar{

public:
	ToolBar(wxWindow * parent,std::string iconsdir);
	~ToolBar(void);

private:

	ToolBarEventHandler* _evthand;
};

#endif
