/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXMARACASSURFACERENDERINGMANAGERDATAMHD_H_
#define WXMARACASSURFACERENDERINGMANAGERDATAMHD_H_


#include "wxMaracasSurfaceRenderingManagerData.h"
#include "boxSurfaceObserver.h"

#include "vtkMetaImageReader.h"
#include "vtkMarchingCubes.h"
#include "vtkCleanPolyData.h"
#include "vtkImageData.h"
#include "vtkClipPolyData.h"
#include "vtkPlanes.h"
#include "vtkImageThreshold.h"
#include "vtkSmoothPolyDataFilter.h"

class wxMaracasSurfaceRenderingManagerDataMhd : public wxMaracasSurfaceRenderingManagerData  {

public:
	
	wxMaracasSurfaceRenderingManagerDataMhd(vtkImageData* imagedata, std::string dataname="", vtkRenderWindowInteractor*  interactor=0);
	~wxMaracasSurfaceRenderingManagerDataMhd();

	
	/**
	**	Adds a prop3D to the world of the application
	**/
	void setVtkImageData(vtkImageData* imagedata);
	
	/**
	**	changes the isovalue in a prop3D
	**/
	void changeIsoValue(double value);	
        /**
        **	changes the isovalue in a prop3D
        **/
        void changeIsoValue(double min, double max);
	/**
	**	Check if the variables are setted correctly
	**/
	void checkInvariant();	
	
	/**
	**	Returns the grey max level of the image
	**/

	int getMaxGreyLevel();

	/**
	**	creates the image 
	**/
	void contourExtractor(int isovalue);		
	
	/**
	** Updates surface
	**/
	void UpdateSurface();

        virtual void enableBoxWidget(bool enable);
private:	
	
	vtkImageData* _imagedata;
	int _maxgreylevel;

	/**
	** to the image render
	**/
	vtkMarchingCubes* _cubesFilter;
        vtkCleanPolyData* _cleanFilter;
	vtkClipPolyData* _tissueClipper;
	vtkPlanes* _tissuePlanes;
        vtkImageThreshold * _tresholdFilter;
        vtkSmoothPolyDataFilter* _smooth;
	
	/**
	** Get's the max grey level of the image
	**/
	int getMaxLevel(vtkImageData* img);
	

	
};

#endif /*WXMARACASSURFACERENDERINGMANAGERDATAMHD_H_*/
