/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXMARACASSURFACERENDERINGPANEL_H_
#define WXMARACASSURFACERENDERINGPANEL_H_

#include "wx/wx.h"

class wxMaracasSurfaceRenderingPanel : public wxPanel{
public:
	wxMaracasSurfaceRenderingPanel(wxWindow* parent, int propid, bool _isComplexBox, int _panID)
		: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize){
			createPanel();
			isComplexBox = _isComplexBox;
			panID = _panID;
			_propid = propid;
	}	
	//virtual ~wxMaracasSurfaceRenderingPanel();
	virtual void createPanel(){
		show = false;
        /*wxBoxSizer* sizerButtons = new wxBoxSizer(wxVERTICAL);

		wxButton* b = new wxButton(this, -1, wxString(_T("-")), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, 
								wxDefaultValidator, wxString(_T("-")));	
		Connect(b->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasSurfaceRenderingPanel::onActionButtonPressedHide);
		wxButton* b1 = new wxButton(this, -1, wxString(_T("-")), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, 
								wxDefaultValidator, wxString(_T("x")));	
		Connect(b1->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasSurfaceRenderingPanel::onActionButtonPressedEliminate);

		sizerButtons->Add(b, wxFIXED_MINSIZE);
		sizerButtons->Add(b1, wxFIXED_MINSIZE);*/

		sizercontrols = new wxBoxSizer(wxVERTICAL);

		wxBoxSizer* sizerpanel = new wxBoxSizer(wxHORIZONTAL);

		//sizerpanel->Add(sizerButtons,wxGROW);
		sizerpanel->Add(sizercontrols,wxGROW);
	
		this->SetSizer(sizerpanel, true);		
		this->SetAutoLayout( true );
	}

	/**
	**	Adds a new control to the panel (sizer, radiob, etc)
	**/
	virtual void addControl(wxWindow* win){
		if(sizercontrols!=NULL){
			sizercontrols->Add(win, wxGROW);
		}
	}

	/**
	**	Adds a new control to the panel (sizer, radiob, etc)
	**/
	virtual void addControl(wxSizer* sizer){
		if(sizercontrols!=NULL){
			sizercontrols->Add(sizer, wxGROW);
		}
	}

	/**
	**	Hides or show the controls in the panel
	**/
	virtual void onActionButtonPressedHide( wxCommandEvent& event ){
	/// \TODO : fix deprecated : wxListBase::operator wxList&() const is deprecated  // JPR
		wxList list = sizercontrols->GetChildren();		
		int i;
		for(i=0; i<(int)list.size();i++){
			sizercontrols->Show(i,show);
		}
		show = !show;
		sizercontrols->Layout();
		this->Layout();
	}

    /**
	**	The user must implement this function to remove the panel from the 
	**/
	//virtual void onActionButtonPressedEliminate( wxCommandEvent& event )=0;

	/**
	**	The user must implement this function to add the necessary controls to the panel
	**/
	virtual void createControls( )=0;
	
	/**
	** returns the id of the panel
	**/
	int getPropId(){
		return _propid;
	}

	/**
	** Returns the papnel id
	**/
	int getPanId(){
		return panID;
	}

	/**
	** Tells if the panel is used for a complex box
	**/
	bool isComplex(){
		return isComplexBox;
	}

private:
	wxBoxSizer* sizercontrols;
	bool show;
protected:
	int _propid;
	
	//-- Atributes added for complex box --//
	bool isComplexBox;
	int panID;
};

#endif /*WXMARACASSURFACERENDERINGPANEL_H_*/
