/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXVTK3DBASEVIEW_H_
#define WXVTK3DBASEVIEW_H_

#include "wxVtkBaseView.h"
#ifdef _DEBUG
#include <crtdbg.h>
#define DEBUG_NEW new(_NORMAL_BLOCK ,__FILE__, __LINE__)
#else
#define DEBUG_NEW new
#endif
//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class creaMaracasVisu_EXPORT wxVtk3DBaseView: public wxVtkBaseView
{
public:
	wxVtk3DBaseView( wxWindow *parent, vtkBaseData* vtkbasedata );
	virtual ~wxVtk3DBaseView();
	vtkCamera*						GetCamera();
	virtual vtkRenderer*			GetRenderer();
	virtual vtkRenderWindow*	GetRenWin();
	void								Refresh();
	void								Configure();
	virtual void					GetSpacing(double spc[3]);
	void								SetStereo(int type);
	void 								ResetCamera(int *ext=NULL,double* spc=NULL);

private:
	bool								_configure;
	vtkRenderer						*_aRenderer;
	vtkRenderWindow				*_renWin;
	vtkCamera						*_aCamera;
protected:
};

#endif /*WXVTK3DBASEVIEW_H_*/
