/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#ifndef __WX_VTK__BASE__VIEW__H
#define __WX_VTK__BASE__VIEW__H



#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkCamera.h>
#include <vtkTextActor.h>

//EEDxx include
#include <vtkProperty.h>
#include <vtkActor.h>


#include <vtkImageViewer2.h> 
#include <vtkInteractorStyleImage.h> 

#include "vtkBaseData.h"
#include "wxVTKRenderWindowInteractorEditContour.h"

#include <wx/wx.h>



#include <vector>
#include "marTypes.h"

#include "wxVTKRenderWindowInteractor.h"
//#include "include/vtkImageViewer2_XYZ.h"

/* JCP 14/05/09
//#include "vtkInteractorStyleBaseView.h"
//class vtkInteractorStyleBaseView;  
 */


#include "vtkInteractorStyleImage.h"

class creaMaracasVisu_EXPORT wxVtkBaseView{
public:
	wxVtkBaseView( );
	wxVtkBaseView( wxWindow *parent );
	virtual ~wxVtkBaseView();
	wxVTKRenderWindowInteractor		*GetWxVTKRenderWindowInteractor() throw (char*);
	virtual void					Configure();
	virtual void					Refresh();
	virtual void					RefreshView();
	virtual vtkRenderer*			GetRenderer();
	virtual vtkRenderWindow*	GetRenWin();
	virtual void					TransFromCoordScreenToWorld(double &X, double &Y, double &Z, bool keepNormalDirection=false,int type=2);

	//RaC 03-2010 Method used by TransFromCoordScreenToWorld
	void								TransCoordScreenToWorld(double &X, double &Y, double &Z,int type=2);

	/* JCP 04/05/09
	void					SetInteractorStyleBaseView( vtkInteractorStyleBaseView*	interactorStyle);
	*/
	void								SetInteractorStyleBaseView( vtkInteractorStyleImage*	interactorStyle);
	/* JCP 04/05/09
	 * 
	vtkInteractorStyleBaseView*		GetInteractorStyleBaseView();	
	*/
	vtkInteractorStyleImage*	GetInteractorStyleBaseView();
	virtual void					GetSpacing(double spc[3]);
	virtual int						GetDirection();


	vtkBaseData*					GetVtkBaseData();
	void								SetVtkBaseData(vtkBaseData *vtkbasedata);


private:
	wxWindow							 *_parent;
	wxVTKRenderWindowInteractor *_iren;
	/**
	 * JCP 04/05/09
	 * vtkInteractorStyleImage		*_interactorStyle;
	 */
	vtkInteractorStyleImage		*_interactorStyle;

// EED Nov 15 2014
	vtkBaseData						*_vtkbasedata;

protected:

};

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------


#endif // __WX_VTK__BASE__VIEW__H

