/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXVTKCLIPPING3DVIEW_H_
#define WXVTKCLIPPING3DVIEW_H_

#include "vtkClipping3DDataViewer.h"
#include "wxVtk3DBaseView.h"
#include "wx/wx.h"
#include "vtkBoxWidget.h"

//#include "wxVtkClipping3DViewCntrlPanel.h"
//class wxVtkClipping3DViewCntrlPanel;

class wxVtkClipping3DView
{
public:
	wxVtkClipping3DView( wxVtk3DBaseView* wxvtk3Dbaseview );
	virtual ~wxVtkClipping3DView();
	virtual void			Refresh();
	virtual void			Configure();
	void						SetVtkClipping3DDataViewer( vtkClipping3DDataViewer *vtkclipping3Ddataviewer );

	wxPanel*					CreateSurfControlPanel(wxWindow *parent);
	wxPanel*					CreateVolControlPanel(wxWindow *parent);

	vtkClipping3DDataViewer*	GetVtkClipping3DDataViewer();

	void						VisibleActor(int idTissue, bool visTissue);
	void						VisibleVolumeActor( bool visVolume );

	void                 VisibleVolumeBoxActor(bool visible);

	void						SetVisibleBoxSurface(bool visible);
	void						SetVisibleBoxVolume(bool visible);
	void						SetRepSurfaceWireFrame(int idTissue , bool typeRepresentation );

	wxVtk3DBaseView*		GetWxvtk3Dbaseview()throw(char*);

	void                 SetRayCasting(bool active);
	void                 SetMIPActive(bool active);
   void                	SetInterpolation(bool active);
   void                	SetShade(bool active);

   void                	UpdateVolumeBox(vector<double> gf, vector<double> vf, vtkColorTransferFunction* ctfun);


private:
	wxVtk3DBaseView				*_wxvtk3Dbaseview;
	vtkClipping3DDataViewer		*_vtkclipping3Ddataviewer;
	vtkBoxWidget					*_boxWidgetS1;
	vtkBoxWidget					*_boxWidgetVolume;
	wxPanel							*_wxvtkclipping3DviewCntrlPanel;
	wxPanel							*_wxvtkclipping3DviewVolCntrlPanel;
protected:
};

#endif /*WXVTKCLIPPING3DVIEW_H_*/
