/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXVTKMPR3DVIEWCNTRLPANEL_H_
#define WXVTKMPR3DVIEWCNTRLPANEL_H_

#include "wxVtkMPR3DView.h"

#include "wx/wx.h"

class wxVtkMPR3DView;

class wxVtkMPR3DViewCntrlPanel: public wxPanel
{
public:
	wxVtkMPR3DViewCntrlPanel(wxWindow *parent, wxVtkMPR3DView *wxvtkmpr3Dview, bool align);
	~wxVtkMPR3DViewCntrlPanel();
	void		OnVisibleAxisX(wxCommandEvent& event);
	void		OnVisibleAxisY(wxCommandEvent& event);
	void		OnVisibleAxisZ(wxCommandEvent& event);
	void		OnPositionX(wxScrollEvent& event);
	void		OnPositionY(wxScrollEvent& event);
	void		OnPositionZ(wxScrollEvent& event);
	void		OnVisibleAxisXYZ(wxCommandEvent& event);
	void		OnVisiblePlane(wxCommandEvent& event);
	void		OnEditColorTable(wxCommandEvent& event);
////EED 05Nov2012	void		On_BW_Color_Plane(wxCommandEvent& event);
	
	void OnVisibleFreePlaneX(wxCommandEvent& event);
	void OnVisibleFreePlaneY(wxCommandEvent& event);
	void OnVisibleFreePlaneZ(wxCommandEvent& event);
	void OnVisibleFreePlaneInteraction(wxCommandEvent& event);
	void OnSetStereo(wxCommandEvent& event);
	void OnFreePlanesOrtho(wxCommandEvent& event);
	void OnOutline(wxCommandEvent& event);
	void OnBackGroundBlack(wxCommandEvent& event);

	virtual void Refresh();
	void		UpdateControlPanel();

	bool		GetVisibleX();
	bool		GetVisibleY();
	bool		GetVisibleZ();
	bool		GetVisibleXYZ();
	bool		GetVisiblePlane();
////EED 05Nov2012	bool		Get_BW_Color_Plane();
	void		SetVisibleX(bool value);
	void		SetVisibleY(bool value);
	void		SetVisibleZ(bool value);
	void		SetVisibleXYZ(bool value);
	void		SetVisiblePlane(bool value);

private:
	wxVtkMPR3DView	*_wxvtkmpr3Dview;

	wxSlider		*_opacity;
	wxSlider		*_isoValue;
	wxSlider		*_isoValueSpin;
	wxStaticText	*_isoValueText;
	wxRadioButton	*_surfA;
	wxRadioButton	*_surfB;
	wxRadioButton	*_surfC;
	wxRadioButton	*_surfD;
	wxCheckBox		*_visible;
	wxButton		*_color;
	wxSlider		*_positionX;
	wxSlider		*_positionY;	
	wxSlider		*_positionZ;
	
	//CPR: Added 30 nov 2009
	wxCheckBox		*_ckBoxX;
	wxCheckBox		*_ckBoxY;
	wxCheckBox		*_ckBoxZ;
	
	//EED 03 nov 2012
////EED 05Nov2012	wxCheckBox		*_ckBox_BW_Color_Plane;
	
	wxCheckBox		*_ckBoxXYZ;
	wxCheckBox		*_ckBoxPlane;
	
	wxCheckBox      *_ckFreePlaneX;
	wxCheckBox      *_ckFreePlaneY;
	wxCheckBox      *_ckFreePlaneZ;
	wxCheckBox      *_ckFreePlaneInteraction;
	
	wxComboBox		*_cbStereo;

	wxCheckBox		*_ckBoxOutline;
	wxCheckBox		*_ckBoxBackGroundBlack;


protected:

};

#endif /*WXVTKMPR3DVIEWCNTRLPANEL_H_*/
