/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sante)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef _VTKVECTORSTENSORSVISUBASE_H_
#define _VTKVECTORSTENSORSVISUBASE_H_


#include "vtkActor.h"
#include "vtkLookupTable.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderer.h"
#include "vtkSmartPointer.h"
#include "vtkVectorNorm.h"


//---------------------------------------------
// Class Name: vtkVectorsTensorsVisuBase
// [classdescription]
//---------------------------------------------




class /*VTK_COMMON_EXPORT*/ vtkLookupTableDirectionVector : public vtkScalarsToColors
{
public:
	// Description:
	// Construct with range=[0,1]; and hsv ranges set up for rainbow color table 
	// (from red to blue).
	static vtkLookupTableDirectionVector *New();
	
	vtkTypeMacro(vtkLookupTableDirectionVector,vtkScalarsToColors);
	void PrintSelf(ostream& os, vtkIndent indent);

	double *GetRange() { return this->GetTableRange(); };
	void SetRange(double min, double max) { this->SetTableRange(min, max); };
	void SetRange(double rng[2]) { this->SetRange(rng[0], rng[1]); };
	
	void SetTableRange(double r[2]); 
	virtual void SetTableRange(double min, double max);
	vtkGetVectorMacro(TableRange,double,2);
			
	unsigned char *MapValue(double v);
	
	void GetColor(double x, double rgb[3]);
	
	void MapScalarsThroughTable2(void *input, unsigned char *output,
								 int inputDataType, int numberOfValues,
								 int inputIncrement, int outputIncrement);
	
	
protected:
	
	 double TableRange[2];
	vtkLookupTableDirectionVector(int sze=256, int ext=256);
	~vtkLookupTableDirectionVector();
	
		
private:
	vtkLookupTableDirectionVector(const vtkLookupTableDirectionVector&);  // Not implemented.
	void operator=(const vtkLookupTableDirectionVector&);  // Not implemented.
};














class vtkVectorsTensorsVisuBase
{

//---------------------------------------------
//Methods and attributes exposed to other classes
//---------------------------------------------
public :
  vtkVectorsTensorsVisuBase();
  ~vtkVectorsTensorsVisuBase();

   void					SetActive(bool);
   void					SetDataObject(vtkDataObject*);
   void					SetRenderer(vtkRenderer *);
   void					SetScaleFactor(double);
   void					SetOpacity(double);
   void					SetTypeForm(int);
   void					SetColorLaw(int);
   void					SetColor(std::vector<double>);

   bool 					GetActive();
   vtkDataObject*		GetDataObject();
   vtkRenderer*		GetRenderer();
   double				GetScaleFactor();
   double				GetOpacity();
   vtkProp3D*			GetProp3D();
   int					GetTypeForm();

   virtual void 		Process();
   void 					VisibilityActor();



//---------------------------------------------
//Methods and attributes exposed only to classes
//that are derived from this class
//---------------------------------------------
protected:

//---------------------------------------------
//Methods and attributes only visible by this class
//---------------------------------------------
private:
   bool 											_actorAdded;

   double 										_scalefactor;
   double 										_opacity;
   vtkDataObject 								*_dataobject;
   vtkRenderer  								*_renderer;
   int											_typeForm;


protected:
   bool 											_firsttime;
   bool											_active;

   vtkSmartPointer<vtkPolyDataMapper> 	_pdm;
   vtkSmartPointer<vtkActor>           _actor;
   vtkLookupTableDirectionVector			*_LutEED;
	int 											_colorlaw;
	double										_colorR,_colorG,_colorB;

};

//-end of _VTKVECTORSTENSORSVISUBASE_H_------------------------------------------------------
#endif
