 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#----------------------------------------------------------------------------
# BINARY DIR MUST BE IN INCLUDE DIRS 
# TO FIND .h OF AUTOMATICALLY GENERATED FILES (e.g. FROM XML)
INCLUDE_DIRECTORIES( ${CMAKE_CURRENT_BINARY_DIR} ) 
# SOURCES DIR MUST ALSO BE IN INCLUDE DIRS FOR FILES COMPILED IN BINARY DIR 
# WHICH NEED TO INCLUDE OTHER FILES OF THE PACKAGE
INCLUDE_DIRECTORIES(${CMAKE_CURRENT_SOURCE_DIR} )
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
# CREATES bb${BBTK_PACKAGE_NAME}_EXPORT.h
CREA_DYNAMIC_LIBRARY_EXPORT(bb${BBTK_PACKAGE_NAME})
INSTALL(
  FILES ${CMAKE_CURRENT_BINARY_DIR}/bb${BBTK_PACKAGE_NAME}_EXPORT.h
  DESTINATION include/bb${BBTK_PACKAGE_NAME} 
  )
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
# CREATES bb${BBTK_PACKAGE_NAME}Package.h
CONFIGURE_FILE(
  ${BBTK_CMAKE_DIR}/bbPackage.h.in
  ${CMAKE_CURRENT_BINARY_DIR}/bb${BBTK_PACKAGE_NAME}Package.h
  @ONLY IMMEDIATE
  ) 
INSTALL(
  FILES ${CMAKE_CURRENT_BINARY_DIR}/bb${BBTK_PACKAGE_NAME}Package.h
  DESTINATION include/bb${BBTK_PACKAGE_NAME} 
  )
#----------------------------------------------------------------------------
  
#----------------------------------------------------------------------------
# CREATES bb${BBTK_PACKAGE_NAME}Package.cxx
CONFIGURE_FILE(
  ${BBTK_CMAKE_DIR}/bbPackage.cxx.in
  ${CMAKE_CURRENT_BINARY_DIR}/bb${BBTK_PACKAGE_NAME}Package.cxx
  @ONLY IMMEDIATE
  )
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
SET_SOURCE_FILES_PROPERTIES(
  ${CMAKE_CURRENT_BINARY_DIR}/bb${BBTK_PACKAGE_NAME}Package.cxx
  PROPERTIES GENERATED ON)
#----------------------------------------------------------------------------


#----------------------------------------------------------------------------
IF(${BBTK_PACKAGE_NAME}_COMPILE_ALL_CXX) 
  FILE(GLOB ${BBTK_PACKAGE_NAME}_CXX_SOURCES "." "*.cxx")
  FILE(GLOB ${BBTK_PACKAGE_NAME}_CPP_SOURCES "." "*.cpp")
  SET(${BBTK_PACKAGE_NAME}_CXX_SOURCES ${${BBTK_PACKAGE_NAME}_CXX_SOURCES} ${${BBTK_PACKAGE_NAME}_CPP_SOURCES})
  FILE(GLOB ${BBTK_PACKAGE_NAME}_H_SOURCES "." "*.h")
ENDIF(${BBTK_PACKAGE_NAME}_COMPILE_ALL_CXX) 

IF(NOT PROJECT_BINARY_DIR STREQUAL ${PROJECT_SOURCE_DIR})
  SET(${BBTK_PACKAGE_NAME}_CXX_SOURCES
    ${${BBTK_PACKAGE_NAME}_CXX_SOURCES}
    bb${BBTK_PACKAGE_NAME}Package
    )
ENDIF(NOT PROJECT_BINARY_DIR STREQUAL ${PROJECT_SOURCE_DIR})
#----------------------------------------------------------------------------




#----------------------------------------------------------------------------
#----------------------------------------------------------------------------
# bbfy
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
IF(${BBTK_PACKAGE_NAME}_COMPILE_ALL_XML) 
  FILE(GLOB ${BBTK_PACKAGE_NAME}_XML_SOURCES "." "*.xml")
ENDIF(${BBTK_PACKAGE_NAME}_COMPILE_ALL_XML) 


#----------------------------------------------------------------------------
FOREACH(xmlfile ${${BBTK_PACKAGE_NAME}_XML_SOURCES})
  GET_FILENAME_COMPONENT(filename "${xmlfile}" NAME_WE) 
  
  SET(BBFY_CXX_OUT ${CMAKE_CURRENT_BINARY_DIR}/${filename}.cxx)
  
  IF (WIN32)
    MAKE_DLL_PATH()
 #   SET(command00 Path=c:/creatis/dlls__RR__%WXWIN%/lib/vc_dll/__RR__%VTK_DIR%__RR__%ITK_DIR%/../../bin/__RR__%PATH%)
 #   STRING(REPLACE "__RR__" "\;" SETPATH ${command00} )
 #   SET(SETPATH set ${command0} &&)

 
 ADD_CUSTOM_COMMAND(
    OUTPUT ${BBFY_CXX_OUT} 
	COMMAND echo ${BBFY_CXX_OUT}
	COMMAND  echo set "Path=${crea_DIR}/bin/\;"${DLL_PATH} 
	COMMAND  echo ${BBTK_BBFY} ${xmlfile} ${BBTK_PACKAGE_NAME} ${CMAKE_CURRENT_BINARY_DIR}/ -q
	COMMAND echo ${BBFY_CXX_OUT}
	COMMAND  set "Path=${crea_DIR}/bin/\;"${DLL_PATH} && ${BBTK_BBFY} ${xmlfile} ${BBTK_PACKAGE_NAME} ${CMAKE_CURRENT_BINARY_DIR}/ -q
 ##  COMMAND  set Path=${DLL_PATH} && ${BBTK_BBFY} ${xmlfile} ${BBTK_PACKAGE_NAME} ${CMAKE_CURRENT_BINARY_DIR}/ -q
    DEPENDS ${xmlfile}
    ${BBTK_BBFY_DEPENDENCY}
    ${BBTK_BBPCONFIGURATOR_DEPENDENCY}
    )
  ELSE(WIN32)
    SET(LD_LIBRARY_PATH "$ENV{LD_LIBRARY_PATH}:${LIBRARY_OUTPUT_PATH}")
    ADD_CUSTOM_COMMAND(
      OUTPUT ${BBFY_CXX_OUT}
      COMMAND
      export LD_LIBRARY_PATH=${LD_LIBRARY_PATH} && echo $ENV{LD_LIBRARY_PATH} && ${BBTK_BBFY} ${xmlfile} ${BBTK_PACKAGE_NAME} ${CMAKE_CURRENT_BINARY_DIR}/ -q
      DEPENDS ${xmlfile}
      ${BBTK_BBFY_DEPENDENCY} 
      )
    
  ENDIF(WIN32)
  
  
  SET_SOURCE_FILES_PROPERTIES(
    ${BBFY_CXX_OUT}
    PROPERTIES GENERATED ON)
  
  
 IF(NOT ${BBTK_PACKAGE_NAME}_CXX_SOURCES MATCHES "${filename}.cxx")
 # message ("EED Alert BBTKConfigurePackage_src  "  "IF NOT MATCHES" )
  SET(${BBTK_PACKAGE_NAME}_CXX_SOURCES
      ${${BBTK_PACKAGE_NAME}_CXX_SOURCES}
      ${filename}.cxx
      )
 ENDIF(NOT ${BBTK_PACKAGE_NAME}_CXX_SOURCES MATCHES "${filename}.cxx") 
  
  INSTALL(
    FILES       ${CMAKE_CURRENT_BINARY_DIR}/${filename}.h 
    DESTINATION include/bb${BBTK_PACKAGE_NAME})  
ENDFOREACH(xmlfile)
#----------------------------------------------------------------------------



#----------------------------------------------------------------------------
# CREATES LIBRARY
#----------------------------------------------------------------------------
# TCL WRAPPING FOR KWWIDGETS
IF(BBTK_USE_KWWIDGETS)
#MESSAGE(STATUS "****TCL=${${BBTK_PACKAGE_NAME}_CXX_SOURCES_WRAP_TCL}")
IF(${BBTK_PACKAGE_NAME}_CXX_SOURCES_WRAP_TCL )
#MESSAGE(STATUS "****TCL OK")
include("${KWWidgets_CMAKE_DIR}/KWWidgetsWrappingMacros.cmake")
kwwidgets_wrap_tcl(bb${BBTK_PACKAGE_NAME} LIB_TCL_SRCS ${${BBTK_PACKAGE_NAME}_CXX_SOURCES_WRAP_TCL} "")
SET(${BBTK_PACKAGE_NAME}_CXX_SOURCES 
  ${${BBTK_PACKAGE_NAME}_CXX_SOURCES} 
  ${LIB_TCL_SRCS})
ENDIF(${BBTK_PACKAGE_NAME}_CXX_SOURCES_WRAP_TCL)
ENDIF(BBTK_USE_KWWIDGETS)
#----------------------------------------------------------------------------
#MESSAGE(STATUS ${${BBTK_PACKAGE_NAME}_CXX_SOURCES})

ADD_LIBRARY(bb${BBTK_PACKAGE_NAME} SHARED 
  ${${BBTK_PACKAGE_NAME}_CXX_SOURCES} ${${BBTK_PACKAGE_NAME}_H_SOURCES}
  )


TARGET_LINK_LIBRARIES(bb${BBTK_PACKAGE_NAME} 
  bbtk
  ${${BBTK_PACKAGE_NAME}_LIBS}
  )
IF(UNIX)
SET_TARGET_PROPERTIES(bb${BBTK_PACKAGE_NAME} PROPERTIES COMPILE_FLAGS -Wall)
ENDIF(UNIX)
#----------------------------------------------------------------------------


#----------------------------------------------------------------------------
# INSTALLS LIBRARY
FILE(GLOB ${BBTK_PACKAGE_NAME}_HEADERS "*.h")
INSTALL(
  FILES ${${BBTK_PACKAGE_NAME}_HEADERS}
  DESTINATION include/bb${BBTK_PACKAGE_NAME}
  )  
INSTALL(
  TARGETS bb${BBTK_PACKAGE_NAME} 
  DESTINATION ${BBTK_PACKAGE_LIB_PATH}
  )


# Preparing macro invocation : CREA_ADVANCED_INSTALL_LIBRARY_FOR_CMAKE
SET( LIBRARY_NAME bb${BBTK_PACKAGE_NAME} )
# SET THE LIB VERSION
SET(${LIBRARY_NAME}_MAJOR_VERSION ${${BBTK_PACKAGE_NAME}_MAJOR_VERSION})
SET(${LIBRARY_NAME}_MINOR_VERSION ${${BBTK_PACKAGE_NAME}_MINOR_VERSION})
SET(${LIBRARY_NAME}_BUILD_VERSION ${${BBTK_PACKAGE_NAME}_BUILD_VERSION})
# 
SET(${LIBRARY_NAME}_INSTALL_FOLDER bb${BBTK_PACKAGE_NAME})
SET(${LIBRARY_NAME}_LIBRARIES bb${BBTK_PACKAGE_NAME})

FILE(RELATIVE_PATH 
  ${LIBRARY_NAME}_BUILD_TREE_RELATIVE_INCLUDE_PATHS 
  ${PROJECT_SOURCE_DIR} ${CMAKE_CURRENT_SOURCE_DIR}
  )

IF ( ${PROJECT_BINARY_DIR} STREQUAL ${EXECUTABLE_OUTPUT_PATH} )
  SET(CILFC_EXECUTABLE_OUTPUT_REL_PATH ".")
ELSE ( ${PROJECT_BINARY_DIR} STREQUAL ${EXECUTABLE_OUTPUT_PATH} )
  FILE(RELATIVE_PATH 
    CILFC_EXECUTABLE_OUTPUT_REL_PATH
    ${PROJECT_BINARY_DIR} ${EXECUTABLE_OUTPUT_PATH})
ENDIF ( ${PROJECT_BINARY_DIR} STREQUAL ${EXECUTABLE_OUTPUT_PATH} )

IF(UNIX)
  SET(${LIBRARY_NAME}_BUILD_TREE_RELATIVE_LIBRARY_PATHS
    ${CILFC_EXECUTABLE_OUTPUT_REL_PATH})
ELSE(UNIX)
  SET(${LIBRARY_NAME}_BUILD_TREE_RELATIVE_LIBRARY_PATHS
    ${CILFC_EXECUTABLE_OUTPUT_REL_PATH})
ENDIF(UNIX)

SET(${LIBRARY_NAME}_INSTALL_TREE_RELATIVE_INCLUDE_PATHS 
  include/bb${BBTK_PACKAGE_NAME})
SET(${LIBRARY_NAME}_INSTALL_TREE_RELATIVE_LIBRARY_PATHS ${BBTK_PACKAGE_LIB_PATH})

# REQUIRED BUILD FLAGS
#SET(${LIBRARY_NAME}_REQUIRED_C_FLAGS "")
#SET(${LIBRARY_NAME}_REQUIRED_CXX_FLAGS "")
#SET(${LIBRARY_NAME}_REQUIRED_LINK_FLAGS "")

# Additional config/use
# Prepare for configure
SET(BBTK_PACKAGE_USE_VTK       ${${BBTK_PACKAGE_NAME}_USE_VTK})
SET(BBTK_PACKAGE_USE_ITK       ${${BBTK_PACKAGE_NAME}_USE_ITK})
SET(BBTK_PACKAGE_USE_QT        ${${BBTK_PACKAGE_NAME}_USE_QT})
SET(BBTK_PACKAGE_USE_GDCM      ${${BBTK_PACKAGE_NAME}_USE_GDCM})
SET(BBTK_PACKAGE_USE_GDCM2     ${${BBTK_PACKAGE_NAME}_USE_GDCM2})
SET(BBTK_PACKAGE_USE_GSMIS     ${${BBTK_PACKAGE_NAME}_USE_GSMIS})
SET(BBTK_PACKAGE_USE_WXWIDGETS ${${BBTK_PACKAGE_NAME}_USE_WXWIDGETS})
SET(BBTK_PACKAGE_USE_PACKAGES  ${${BBTK_PACKAGE_NAME}_USE_PACKAGES})
SET(BBTK_PACKAGE_INCLUDE_DIRS  ${${BBTK_PACKAGE_NAME}_INCLUDE_DIRS})
SET(BBTK_PACKAGE_LIBS          ${${BBTK_PACKAGE_NAME}_LIBS})

SET(${LIBRARY_NAME}_HAS_ADDITIONAL_CONFIG_FILE TRUE)
SET(${LIBRARY_NAME}_ADDITIONAL_CONFIG_FILE 
  ${${BBTK_PACKAGE_NAME}_SOURCE_DIR}/PackageConfig.cmake.in)
SET(${LIBRARY_NAME}_ADDITIONAL_USE_FILE 
  ${${BBTK_PACKAGE_NAME}_SOURCE_DIR}/UsePackage.cmake.in)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
CREA_ADVANCED_INSTALL_LIBRARY_FOR_CMAKE(${LIBRARY_NAME})
#-----------------------------------------------------------------------------

#----------------------------------------------------------------------------




#---------------------------------------------------------------------------
IF(CHCON_LIBRARIES)
  # On recent linux running SELinux : 
  # Have to change the context of the library created 
  # to be able to load it dynamically and avoid the error : 
  # "cannot restore segment prot after reloc: Permission denied"
  # see e.g. 
  # http://www.ittvis.com/services/techtip.asp?ttid=3092
  # Try to find chcon
  FIND_PROGRAM(CHCON_EXECUTABLE
    NAMES chcon
    PATHS
    /usr/bin
    /usr/local/bin
    )
  MARK_AS_ADVANCED(CHCON_EXECUTABLE)
  IF(CHCON_EXECUTABLE)
    # chcon found 
    # custom post_build command to change the context of the .so generated
    ADD_CUSTOM_COMMAND(
      TARGET bb${BBTK_PACKAGE_NAME}
      POST_BUILD
      COMMAND chcon -t texrel_shlib_t ${LIBRARY_OUTPUT_PATH}/libbb${BBTK_PACKAGE_NAME}.so
      ) 
    # custom post-install command to change the context of the .so installed
    INSTALL(CODE "EXEC_PROGRAM(chcon ARGS -t texrel_shlib_t ${CMAKE_INSTALL_PREFIX}/lib/libbb${BBTK_PACKAGE_NAME}.so)")
  ENDIF(CHCON_EXECUTABLE)
ENDIF(CHCON_LIBRARIES)
#----------------------------------------------------------------------------



#----------------------------------------------------------------------------
#  bbpConfigurator
#----------------------------------------------------------------------------
# --Creates the file ${BBTK_PACKAGE_NAME}.bbp-- 
## bbpConfigurator   create de PACKAGE.bbp file
## bbConfigurator <path_to_bbs> <package_name> <output_path>



IF (WIN32)
    MAKE_DLL_PATH()
##    ADD_CUSTOM_TARGET( ${BBTK_PACKAGE_NAME}.bbp  ALL
ADD_CUSTOM_COMMAND(
##    OUTPUT ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}.bbp
        TARGET bb${BBTK_PACKAGE_NAME} POST_BUILD
        COMMAND  set "Path=${crea_DIR}/bin/\;"${DLL_PATH} && ${BBTK_BBPCONFIGURATOR} ${CMAKE_CURRENT_SOURCE_DIR}/../bbs/boxes/  ${BBTK_PACKAGE_NAME}  ${BBTK_BBS_BUILD_PATH}/
##		DEPENDS ${BBTK_BBPCONFIGURATOR_DEPENDENCY} 
	  ) 
    add_dependencies( bb${BBTK_PACKAGE_NAME}  bbpConfigurator )
ELSE(WIN32)
    SET(LD_LIBRARY_PATH "$ENV{LD_LIBRARY_PATH}:${LIBRARY_OUTPUT_PATH}")
    ADD_CUSTOM_TARGET( bb${BBTK_PACKAGE_NAME}.bbp  ALL
         COMMAND  ${BBTK_BBPCONFIGURATOR} ${CMAKE_CURRENT_SOURCE_DIR}/../bbs/boxes/  ${BBTK_PACKAGE_NAME}  ${BBTK_BBS_BUILD_PATH}/
    ) 
    add_dependencies( bb${BBTK_PACKAGE_NAME}.bbp  bbpConfigurator )
ENDIF(WIN32)



SET(OUTPUT_FILE ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}.bbp)
IF(WIN32)
   INSTALL(
     FILES ${OUTPUT_FILE}
#    DESTINATION ${BBTK_BBS_INSTALL_PATH}
     DESTINATION ${BBTK_BBS_REL_PATH}
    )
ELSE(WIN32	)
     INSTALL(
       FILES ${OUTPUT_FILE}
       DESTINATION ${BBTK_BBS_INSTALL_PATH}
#      DESTINATION ${BBTK_BBS_REL_PATH}
     )
ENDIF(WIN32)

