 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


MACRO(BBTK_CREATE_PACKAGE_BBDOC PACKAGE_NAME)
  # Creates output dir if it does not exist
  MKDIR(${BBTK_BBDOC_BUILD_PATH}/${PACKAGE_NAME})

  # Create file make_doc_${PACKAGE_NAME}.bbs
  SET(OUTPUT_PATH ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}/appli)
  SET(OUTPUT_FILE ${OUTPUT_PATH}/make_doc_${PACKAGE_NAME}.bbs)
  SET(DOC_OUTPUT ${BBTK_BBDOC_BUILD_PATH}/${PACKAGE_NAME}/index.html)
  FILE(WRITE 
    "${OUTPUT_FILE}" 
    "#-----------------------------------------\n"
    "# Generates the html doc for package '${PACKAGE_NAME}'\n"
    "# Automatically generated by cmake (macro BBTK_CREATE_PACKAGE_BBDOC)\n")
  FILE(APPEND 
    "${OUTPUT_FILE}"
    "#-----------------------------------------\n"
    "exec freeze\n"
    "include ${PACKAGE_NAME}\n"
    "include ${PACKAGE_NAME}-appli\n"
    "#-----------------------------------------\n"
#    "graph ${PACKAGE_NAME} 0 0 ${DOC_OUTPUT} \"${CMAKE_CURRENT_BINARY_DIR}/header.html\" \"Package ${PACKAGE_NAME} documentation\"\n"
    "graph ${PACKAGE_NAME} 0 0 ${DOC_OUTPUT} \"${BBTK_BBDOC_BUILD_PATH}/${BBTK_PACKAGE_NAME}/header.html\" \"Package ${PACKAGE_NAME} documentation\"\n"

    )
  IF(WIN32)
  INSTALL(
    FILES ${OUTPUT_FILE}
    DESTINATION ${BBTK_BBS_REL_PATH}/${BBTK_PACKAGE_NAME}/appli
    )
  ELSE(WIN32)
  INSTALL(
    FILES ${OUTPUT_FILE}
    DESTINATION ${BBTK_BBS_INSTALL_PATH}/${BBTK_PACKAGE_NAME}/appli
    )
  ENDIF(WIN32)
  

  #
  IF(WIN32)
    SET(USE_DOT TRUE)
    MAKE_DLL_PATH()
#    FILE(TO_NATIVE_PATH ${EXECUTABLE_OUTPUT_PATH}/bb${BBTK_PACKAGE_NAME}.dll  pathCommand2 )	
    FILE(TO_NATIVE_PATH  ${BBTK_BIN_PATH}/bbtk_config.xml pathCommand2 )	
    FILE(TO_NATIVE_PATH ${PROJECT_BINARY_DIR}/${BBTK_BBS_REL_PATH} pathCommand1 )
    set(command1 cd ${pathCommand1}) 
    set(command2 copy ${pathCommand2} . )   
    set(command3 ${BBTK_BBI} -N -q ${OUTPUT_FILE}) 
    set(command4 echo done)
    #del bb${BBTK_PACKAGE_NAME}.dll)
    
    ADD_CUSTOM_COMMAND(
      OUTPUT ${DOC_OUTPUT}
      COMMAND 
      #    cd ${BBTK_BIN_PATH}/../bbs/ && ${BBTK_BBI} -n ${OUTPUT_FILE}
      set ${DLL_PATH} && ${command1} && ${command2} && ${command3} 
      #&& ${command4}
      DEPENDS bb${PACKAGE_NAME} 
      )
  ELSE(WIN32)
    SET(LD_LIBRARY_PATH "$ENV{LD_LIBRARY_PATH}:${LIBRARY_OUTPUT_PATH}")
    ADD_CUSTOM_COMMAND(
      OUTPUT ${DOC_OUTPUT}
      COMMAND 
      cd ${EXECUTABLE_OUTPUT_PATH} && export LD_LIBRARY_PATH=${LD_LIBRARY_PATH} && ${BBTK_BBI} -N -q ${OUTPUT_FILE} ${BBTK_MAKE_INDEX}
      DEPENDS bb${PACKAGE_NAME} 
      )


  ENDIF(WIN32)
  ADD_CUSTOM_TARGET(bbdoc_${PACKAGE_NAME} ALL
    DEPENDS ${DOC_OUTPUT} 
    )

  IF(WIN32)
  INSTALL( 
    DIRECTORY ${BBTK_BBDOC_BUILD_PATH}/${PACKAGE_NAME}
    DESTINATION ${BBTK_BBDOC_INSTALL_PATH}
    #DESTINATION ${BBTK_BBDOC_REL_PATH}
    )   
  ELSE(WIN32)
  INSTALL( 
    DIRECTORY ${BBTK_BBDOC_BUILD_PATH}/${PACKAGE_NAME}
    #DESTINATION ${BBTK_BBDOC_INSTALL_PATH}
    DESTINATION ${BBTK_BBDOC_REL_PATH}
    )   
  ENDIF(WIN32)

  IF(NOT WIN32)
    # runs bbtk-make-index as a post install step
    # does not work on windaube
    IF(NOT BBTK_CORE_PACKAGE)
      INSTALL(CODE "EXECUTE_PROCESS(COMMAND ${BBTK_BIN_PATH}/bbtk-make-index)")
    ENDIF(NOT BBTK_CORE_PACKAGE)
  ENDIF(NOT WIN32)

  
ENDMACRO(BBTK_CREATE_PACKAGE_BBDOC NAME)

