 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */




MACRO(BBTK_CREATE_PACKAGE_INCLUDE_SCRIPT    BBTK_PACKAGE_NAME    BBTK_PACKAGE_BBS_BOXES    BBTK_PACKAGE_BBS_APPLI  BBTK_PACKAGE_BBG_BOXES    BBTK_PACKAGE_BBG_APPLI )


  ##  --Configure and installing bbg boxes--
  FOREACH(bbg ${BBTK_PACKAGE_BBG_BOXES})  
    CONFIGURE_FILE(
      ${CMAKE_CURRENT_SOURCE_DIR}/${bbg}
      ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}/${bbg}
      COPYONLY
      )
    GET_FILENAME_COMPONENT(bbg_path ${bbg} PATH)    
    IF(WIN32)
	INSTALL(
      		FILES ${CMAKE_CURRENT_SOURCE_DIR}/${bbg}
      		DESTINATION ${BBTK_BBS_REL_PATH}/${BBTK_PACKAGE_NAME}/${bbg_path}
    	)
    ELSE(WIN32)
	INSTALL(
      		FILES ${CMAKE_CURRENT_SOURCE_DIR}/${bbg}
      		DESTINATION ${BBTK_BBS_INSTALL_PATH}/${BBTK_PACKAGE_NAME}/${bbg_path}
    	)
    ENDIF(WIN32)
  ENDFOREACH(bbg)


  ##  --Configure and installing bbg appli--
  FOREACH(bbg ${BBTK_PACKAGE_BBG_APPLI})  
    CONFIGURE_FILE(
      ${CMAKE_CURRENT_SOURCE_DIR}/${bbg}
      ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}/${bbg}
      COPYONLY
      )
    GET_FILENAME_COMPONENT(bbg_path ${bbg} PATH)    
    IF(WIN32)
	INSTALL(
      		FILES ${CMAKE_CURRENT_SOURCE_DIR}/${bbg}
      		DESTINATION ${BBTK_BBS_REL_PATH}/${BBTK_PACKAGE_NAME}/${bbg_path}
    	)
    ELSE(WIN32)
	INSTALL(
      		FILES ${CMAKE_CURRENT_SOURCE_DIR}/${bbg}
      		DESTINATION ${BBTK_BBS_INSTALL_PATH}/${BBTK_PACKAGE_NAME}/${bbg_path}
    	)
    ENDIF(WIN32)
  ENDFOREACH(bbg)








  ##  --Configure and installing bbs boxes--
 


##EED 24/06/2013
##  FILE(WRITE 
##    "${OUTPUT_FILE}" 
##    "#-----------------------------------------\n"
##    "# Include script for bbtk package '${BBTK_PACKAGE_NAME}'\n"
##    "# Automatically generated by cmake (macro BBTK_CREATE_PACKAGE_INCLUDE_SCRIPT)\n")
##  FILE(APPEND 
##    "${OUTPUT_FILE}"
##    "#-----------------------------------------\n"
##    "load ${BBTK_PACKAGE_NAME}\n"
##    "#-----------------------------------------\n"
##    "package ${BBTK_PACKAGE_NAME}\n"
##    )
##  
##  #FILE(APPEND 
##  #  "${OUTPUT_FILE}"
##  #  "#-----------------------------------------\n"
##  #  "include ${BBTK_PACKAGE_NAME}/boxes/*\n"
##  #  )
##  

  FOREACH(bbs ${BBTK_PACKAGE_BBS_BOXES})  

##EED 24/06/2013
##    FILE(APPEND 
##      "${OUTPUT_FILE}"
##      "#-----------------------------------------\n"
##      "include ${BBTK_PACKAGE_NAME}/${bbs}\n"
##      )

    CONFIGURE_FILE(
      ${CMAKE_CURRENT_SOURCE_DIR}/${bbs}
      ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}/${bbs}
      COPYONLY
      )
    GET_FILENAME_COMPONENT(bbs_path ${bbs} PATH)
    
    
    IF(WIN32)
      INSTALL(
        FILES ${CMAKE_CURRENT_SOURCE_DIR}/${bbs}
#       DESTINATION ${BBTK_BBS_INSTALL_PATH}/${BBTK_PACKAGE_NAME}/${bbs_path}
        DESTINATION ${BBTK_BBS_REL_PATH}/${BBTK_PACKAGE_NAME}/${bbs_path}
      )
    ELSE(WIN32)
      INSTALL(
        FILES ${CMAKE_CURRENT_SOURCE_DIR}/${bbs}
        DESTINATION ${BBTK_BBS_INSTALL_PATH}/${BBTK_PACKAGE_NAME}/${bbs_path}
#       DESTINATION ${BBTK_BBS_REL_PATH}/${BBTK_PACKAGE_NAME}/${bbs_path}
      )
    ENDIF(WIN32)

  ENDFOREACH(bbs)



##EED 24/06/2013
##  ##  --Configure and installing bbs appli--
##  FILE(APPEND 
##    "${OUTPUT_FILE}"
##      "#-----------------------------------------\n"
##      "endpackage\n"
##      "#-- EOF ----------------------------------\n"
##    )





  # Creates the file ${BBTK_PACKAGE_NAME}-appli.bbp
  SET(OUTPUT_FILE ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}-appli.bbp)
  FILE(WRITE 
    "${OUTPUT_FILE}" 
    "#-----------------------------------------\n"
    "# Applications include script for bbtk package '${BBTK_PACKAGE_NAME}'\n"
    "# Automatically generated by cmake (macro BBTK_CREATE_PACKAGE_INCLUDE_SCRIPT)\n")
  FILE(APPEND 
    "${OUTPUT_FILE}"
    "#-----------------------------------------\n"
    "load ${BBTK_PACKAGE_NAME}\n"
    "#-----------------------------------------\n"
    "package ${BBTK_PACKAGE_NAME}\n"
    )

  FOREACH(bbs ${BBTK_PACKAGE_BBS_APPLI}) 
 
    GET_FILENAME_COMPONENT(filename "${bbs}" NAME_WE) 
    FILE(APPEND 
      "${OUTPUT_FILE}"
      "#-----------------------------------------\n"
      "define ${filename}\n"
      "include ${BBTK_PACKAGE_NAME}/${bbs} source\n"
      "endefine\n"
      )
      
    CONFIGURE_FILE(
      ${CMAKE_CURRENT_SOURCE_DIR}/${bbs}
      ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}/${bbs}
      COPYONLY
      )
    GET_FILENAME_COMPONENT(bbs_path ${bbs} PATH)
    
    
    IF(WIN32)
    INSTALL(
      FILES ${CMAKE_CURRENT_SOURCE_DIR}/${bbs}
  #    DESTINATION ${BBTK_BBS_INSTALL_PATH}/${BBTK_PACKAGE_NAME}/${bbs_path}
      DESTINATION ${BBTK_BBS_REL_PATH}/${BBTK_PACKAGE_NAME}/${bbs_path}
      )
ELSE(WIN32)
    INSTALL(
      FILES ${CMAKE_CURRENT_SOURCE_DIR}/${bbs}
      DESTINATION ${BBTK_BBS_INSTALL_PATH}/${BBTK_PACKAGE_NAME}/${bbs_path}
  #    DESTINATION ${BBTK_BBS_REL_PATH}/${BBTK_PACKAGE_NAME}/${bbs_path}
      )
ENDIF(WIN32)
  ENDFOREACH(bbs)
  FILE(APPEND 
    "${OUTPUT_FILE}"
      "#-----------------------------------------\n"
      "endpackage\n"
      "#-- EOF ----------------------------------\n"
    )
IF(WIN32)  
  INSTALL(
    FILES ${OUTPUT_FILE}
   # DESTINATION ${BBTK_BBS_INSTALL_PATH}
    DESTINATION ${BBTK_BBS_REL_PATH}
    )
ELSE(WIN32)  
  INSTALL(
    FILES ${OUTPUT_FILE}
    DESTINATION ${BBTK_BBS_INSTALL_PATH}
   # DESTINATION ${BBTK_BBS_REL_PATH}
    )
ENDIF(WIN32)  
#  ADD_CUSTOM_TARGET(${BBTK_PACKAGE_NAME}.bbp ALL
#    DEPENDS  ${OUTPUT_FILE}
#    )


ENDMACRO(BBTK_CREATE_PACKAGE_INCLUDE_SCRIPT)
