 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#========================================================================
# MACRO WHICH COPIES ALL IMAGES (png, jpg, gif) 
# FROM SOURCE TREE TO DOC BUILD TREE
# AND INSTALL THEM IN BBTK DOC TREE
MACRO(BBTK_DOC_INSTALL_IMAGES DOC_RELATIVE_INSTALL_PATH)
  MESSAGE(STATUS "* Copying png,jpg,tif images in ${BBTK_DOC_BUILD_PATH}/${DOC_RELATIVE_INSTALL_PATH}")
  FILE(GLOB PNG_IMAGES "*.png")
  FILE(GLOB JPG_IMAGES "*.jpg")
  FILE(GLOB TIF_IMAGES "*.tif")
  SET(IMAGES
    ${PNG_IMAGES}
    ${JPG_IMAGES}
    ${TIF_IMAGES}
    )
#    MESSAGE(ERROR ${IMAGES} )
  FOREACH(image ${IMAGES})  
    GET_FILENAME_COMPONENT(filename "${image}" NAME)
    CONFIGURE_FILE(
      ${image}
       ${BBTK_DOC_BUILD_PATH}/${DOC_RELATIVE_INSTALL_PATH}/${filename}
      COPYONLY
      ) 
      
    #  IF (WIN32)
#	CONFIGURE_FILE(
#          ${image}
#          ${CMAKE_CURRENT_BINARY_DIR}/${filename}
#          COPYONLY
#	  )
#      ENDIF(WIN32)
    # MESSAGE(ERROR "${image} (${filename}) in :  ${PROJECT_BINARY_DIR}/${BBTK_DOC_INSTALL_PATH}/${DOC_RELATIVE_INSTALL_PATH}/${filename}")
  ENDFOREACH(image)
  INSTALL( 
      FILES ${IMAGES} 
      DESTINATION ${BBTK_DOC_INSTALL_PATH}/${DOC_RELATIVE_INSTALL_PATH}
    )  
ENDMACRO(BBTK_DOC_INSTALL_IMAGES)
#========================================================================



#========================================================================
MACRO(MAKE_DLL_PATH)
  IF(WIN32)
    IF(USE_DOT)
      IF (NOT DOT_DIR)
        FIND_PATH(DOT_DIR dot.exe PATHS $ENV{PATH} )
        IF(NOT DOT_DIR)
          MESSAGE(FATAL_ERROR "Dot not found : set DOT_DIR to the folder containing dot.exe")
        ELSE(NOT DOT_DIR)
          MESSAGE(STATUS "Looking for dot... - found in ${DOT_DIR}")
         ENDIF(NOT DOT_DIR)
      ENDIF(NOT DOT_DIR)
    ENDIF(USE_DOT)	
#    SET(DLL_PATHA Path=${ADDITIONAL_DLL_PATH}__RR__%WXWIN%/lib/vc_dll/__RR__%VTK_DIR%__RR__%ITK_DIR%/../../bin/__RR__%PATH%__RR__${DOT_DIR})
    SET(DLL_PATHA ${ADDITIONAL_DLL_PATH}__RR__${DOT_DIR}__RR__)
		
    FOREACH(APATH $ENV{PATH})
	  SET(DLL_PATHA ${DLL_PATHA}__RR__${APATH})
    ENDFOREACH(APATH)
    STRING(REPLACE "__RR__" "\;" DLL_PATH ${DLL_PATHA} )
  ENDIF(WIN32)  
ENDMACRO(MAKE_DLL_PATH)
#========================================================================
