# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


#-----------------------------------------------------------------------------
#
# creaContoursConfig.cmake - CMake configuration file for external projects.
# This file was automatically generated by the cmake macro 
# CREA_INSTALL_LIBRARY_FOR_CMAKE of the package CREA
#
# This file is configured by cmake and used by the
# UsecreaContours.cmake module to load the lib settings 
# for an external project.

# Build tree config ?
SET(CILC_BUILD_TREE_CONFIGURATION FALSE)


IF(UNIX)
SET(GOTO_INSTALL_PREFIX /../../..)
ENDIF(UNIX)


# The creaContours include file *RELATIVE* directories.
SET(CILC_RELATIVE_INCLUDE_PATHS "include/creaContours")
# Compute the prefix for include and library paths
IF(CILC_BUILD_TREE_CONFIGURATION)
  # In build tree 
  # the include paths are relative to the source tree *AND* the binary tree 
  # for generated files 
  SET(CILC_INCLUDE_PATH_PREFIX /home/davila/Creatis/creaTools/creatools_source/creaContours)
  # Build the *ABSOLUTE* directories
  FOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
    SET(creaContours_INCLUDE_DIRS
      ${creaContours_INCLUDE_DIRS}
      ${CILC_INCLUDE_PATH_PREFIX}/${path}
      )
  ENDFOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
  SET(CILC_INCLUDE_PATH_PREFIX /home/davila/Creatis/creaTools/creatools_bin/creaContoursBin)
  # Build the *ABSOLUTE* directories
  FOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
    SET(creaContours_INCLUDE_DIRS
      ${creaContours_INCLUDE_DIRS}
      ${CILC_INCLUDE_PATH_PREFIX}/${path}
      )
  ENDFOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
ELSE(CILC_BUILD_TREE_CONFIGURATION)
  # In install tree 
  # the include paths are relative to install prefix 
  # On unix , GOTO_INSTALL_PREFIX allows to get back to the 
  # installation prefix from  creaContours_DIR
  SET(CILC_INCLUDE_PATH_PREFIX ${creaContours_DIR}${GOTO_INSTALL_PREFIX})
  # Build the *ABSOLUTE* directories
  FOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
    SET(creaContours_INCLUDE_DIRS
      ${creaContours_INCLUDE_DIRS}
      ${CILC_INCLUDE_PATH_PREFIX}/${path}
      )
  ENDFOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
ENDIF(CILC_BUILD_TREE_CONFIGURATION)



# Compute the prefix for library paths
IF(CILC_BUILD_TREE_CONFIGURATION)
  # In build tree
  # the library paths are relative to the binary tree 
  SET(CILC_LIBRARY_PATH_PREFIX /home/davila/Creatis/creaTools/creatools_bin/creaContoursBin)
ELSE(CILC_BUILD_TREE_CONFIGURATION)
  # In install tree 
  # the library paths are relative to install prefix
  SET(CILC_LIBRARY_PATH_PREFIX ${creaContours_DIR}${GOTO_INSTALL_PREFIX})
ENDIF(CILC_BUILD_TREE_CONFIGURATION)
# The creaContours library file *RELATIVE* directories.
SET(CILC_RELATIVE_LIBRARY_PATHS "lib64/creatools")
# Build the *ABSOLUTE* directories
FOREACH(path ${CILC_RELATIVE_LIBRARY_PATHS})
  SET(creaContours_LIBRARY_DIRS
    ${creaContours_LIBRARY_DIRS}
    ${CILC_LIBRARY_PATH_PREFIX}/${path}
    )
ENDFOREACH(path ${CILC_RELATIVE_LIBRARY_PATHS})

# Set the "prefix path"
SET(creaContours_INSTALL_PREFIX ${CILC_LIBRARY_PATH_PREFIX})

# The C and C++ flags added by creaContours to the cmake-configured flags.
SET(creaContours_REQUIRED_C_FLAGS "")
SET(creaContours_REQUIRED_CXX_FLAGS "")
SET(creaContours_REQUIRED_LINK_FLAGS "")

# The creaContours version 
SET(creaContours_MAJOR_VERSION )
SET(creaContours_MINOR_VERSION )
SET(creaContours_BUILD_VERSION )
SET(creaContours_VERSION ..)

# The location of the UsecreaContours.cmake file.
SET(creaContours_USE_FILE "${creaContours_DIR}/UsecreaContours.cmake")

# The build settings file.
SET(creaContours_BUILD_SETTINGS_FILE 
  "${creaContours_DIR}/creaContoursBuildSettings.cmake")

# A list of all libraries for creaContours.  Those listed here should
# automatically pull in their dependencies.
SET(creaContours_LIBRARIES Interface_ManagerContour_NDimensions_lib;Interface_Icons_NDimensions_lib;kernel_ManagerContour_NDimensions_lib)

# Messages
IF(CREA_VERBOSE_CMAKE)
  MESSAGE(STATUS "=======================================")
  MESSAGE(STATUS "Looking for creaContours... found:")
  MESSAGE(STATUS "* creaContours_DIR          = ${creaContours_DIR}")
  MESSAGE(STATUS "* creaContours_VERSION      = ${creaContours_VERSION}")
  MESSAGE(STATUS "* creaContours_USE_FILE     = ${creaContours_USE_FILE}")

  MESSAGE(STATUS "* creaContours_INCLUDE_DIRS = ${creaContours_INCLUDE_DIRS}")
  MESSAGE(STATUS "* creaContours_LIBRARY_DIRS = ${creaContours_LIBRARY_DIRS}")
  MESSAGE(STATUS "* creaContours_LIBRARIES    = ${creaContours_LIBRARIES}")
ENDIF(CREA_VERBOSE_CMAKE)

# Does the library has an additional config file (user provided) ?
SET(creaContours_HAS_ADDITIONAL_CONFIG_FILE FALSE)

IF (creaContours_HAS_ADDITIONAL_CONFIG_FILE)
  IF(CREA_VERBOSE_CMAKE)
    MESSAGE(STATUS "Reading creaContours additional configuration file")
  ENDIF(CREA_VERBOSE_CMAKE)
  # Include it
  INCLUDE(${creaContours_DIR}/AdditionalcreaContoursConfig.cmake)
ENDIF (creaContours_HAS_ADDITIONAL_CONFIG_FILE)
