# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if BBTK is found.  
# If BBTK is not found, BBTK_FOUND is set to false.
#  BBTK_FOUND         - Set to true when BBTK is found.
#  BBTK_USE_FILE      - CMake file to use BBTK.
#  BBTK_MAJOR_VERSION - The BBTK major version number.
#  BBTK_MINOR_VERSION - The BBTK minor version number 
#                       (odd non-release).
#  BBTK_BUILD_VERSION - The BBTK patch level 
#                       (meaningless for odd minor).
#  BBTK_INCLUDE_DIRS  - Include directories for BBTK
#  BBTK_LIBRARY_DIRS  - Link directories for BBTK libraries
#  BBTK_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate BBTK:
#  BBTK_DIR  - The directory containing BBTKConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/BBTK directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(BBTK_DIR_DESCRIPTION "directory containing BBTKConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/BBTK for an installation.")
SET(BBTK_NOT_FOUND_MESSAGE "BBTK not found.  Set the BBTK_DIR cmake cache entry to the ${BBTK_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT BBTK_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" BBTK_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" BBTK_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" BBTK_DIR_SEARCH2 "${BBTK_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(BBTK_DIR_SEARCH "")
  FOREACH(dir ${BBTK_DIR_SEARCH2})
    SET(BBTK_DIR_SEARCH ${BBTK_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbtk
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(BBTK_DIR UseBBTK.cmake
    # Look for an environment variable BBTK_DIR.
    $ENV{BBTK_DIR}

    # Look in places relative to the system executable search path.
    ${BBTK_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/BBTK"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbtk
    /usr/lib64/creatools/bbtk

    # Read from the CMakeSetup registry entries.  It is likely that
    # BBTK will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${BBTK_DIR_DESCRIPTION}"
  )
ENDIF(NOT BBTK_DIR)

# If BBTK was found, load the configuration file to get the rest of the
# settings.
IF(BBTK_DIR)
  # Make sure the BBTKConfig.cmake file exists in the directory provided.
  IF(EXISTS ${BBTK_DIR}/BBTKConfig.cmake)

    # We found BBTK.  Load the settings.
    SET(BBTK_FOUND 1)
    INCLUDE(${BBTK_DIR}/BBTKConfig.cmake)

  ENDIF(EXISTS ${BBTK_DIR}/BBTKConfig.cmake)
ELSE(BBTK_DIR)
  # We did not find BBTK.
  SET(BBTK_FOUND 0)
ENDIF(BBTK_DIR)

#-----------------------------------------------------------------------------
IF(NOT BBTK_FOUND)
  # BBTK not found, explain to the user how to specify its location.
  IF(NOT BBTK_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${BBTK_NOT_FOUND_MESSAGE})
  ELSE(NOT BBTK_FIND_QUIETLY)
    IF(BBTK_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${BBTK_NOT_FOUND_MESSAGE})
    ENDIF(BBTK_FIND_REQUIRED)
  ENDIF(NOT BBTK_FIND_QUIETLY)
ENDIF(NOT BBTK_FOUND)
