# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if BaseSurfaceRenderer is found.  
# If BaseSurfaceRenderer is not found, BaseSurfaceRenderer_FOUND is set to false.
#  BaseSurfaceRenderer_FOUND         - Set to true when BaseSurfaceRenderer is found.
#  BaseSurfaceRenderer_USE_FILE      - CMake file to use BaseSurfaceRenderer.
#  BaseSurfaceRenderer_MAJOR_VERSION - The BaseSurfaceRenderer major version number.
#  BaseSurfaceRenderer_MINOR_VERSION - The BaseSurfaceRenderer minor version number 
#                       (odd non-release).
#  BaseSurfaceRenderer_BUILD_VERSION - The BaseSurfaceRenderer patch level 
#                       (meaningless for odd minor).
#  BaseSurfaceRenderer_INCLUDE_DIRS  - Include directories for BaseSurfaceRenderer
#  BaseSurfaceRenderer_LIBRARY_DIRS  - Link directories for BaseSurfaceRenderer libraries
#  BaseSurfaceRenderer_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate BaseSurfaceRenderer:
#  BaseSurfaceRenderer_DIR  - The directory containing BaseSurfaceRendererConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/BaseSurfaceRenderer directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(BaseSurfaceRenderer_DIR_DESCRIPTION "directory containing BaseSurfaceRendererConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/BaseSurfaceRenderer for an installation.")
SET(BaseSurfaceRenderer_NOT_FOUND_MESSAGE "BaseSurfaceRenderer not found.  Set the BaseSurfaceRenderer_DIR cmake cache entry to the ${BaseSurfaceRenderer_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT BaseSurfaceRenderer_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" BaseSurfaceRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" BaseSurfaceRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" BaseSurfaceRenderer_DIR_SEARCH2 "${BaseSurfaceRenderer_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(BaseSurfaceRenderer_DIR_SEARCH "")
  FOREACH(dir ${BaseSurfaceRenderer_DIR_SEARCH2})
    SET(BaseSurfaceRenderer_DIR_SEARCH ${BaseSurfaceRenderer_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/creaMaracasVisu
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(BaseSurfaceRenderer_DIR UseBaseSurfaceRenderer.cmake
    # Look for an environment variable BaseSurfaceRenderer_DIR.
    $ENV{BaseSurfaceRenderer_DIR}

    # Look in places relative to the system executable search path.
    ${BaseSurfaceRenderer_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/BaseSurfaceRenderer"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/creaMaracasVisu
    /usr/lib64/creatools/creaMaracasVisu

    # Read from the CMakeSetup registry entries.  It is likely that
    # BaseSurfaceRenderer will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${BaseSurfaceRenderer_DIR_DESCRIPTION}"
  )
ENDIF(NOT BaseSurfaceRenderer_DIR)

# If BaseSurfaceRenderer was found, load the configuration file to get the rest of the
# settings.
IF(BaseSurfaceRenderer_DIR)
  # Make sure the BaseSurfaceRendererConfig.cmake file exists in the directory provided.
  IF(EXISTS ${BaseSurfaceRenderer_DIR}/BaseSurfaceRendererConfig.cmake)

    # We found BaseSurfaceRenderer.  Load the settings.
    SET(BaseSurfaceRenderer_FOUND 1)
    INCLUDE(${BaseSurfaceRenderer_DIR}/BaseSurfaceRendererConfig.cmake)

  ENDIF(EXISTS ${BaseSurfaceRenderer_DIR}/BaseSurfaceRendererConfig.cmake)
ELSE(BaseSurfaceRenderer_DIR)
  # We did not find BaseSurfaceRenderer.
  SET(BaseSurfaceRenderer_FOUND 0)
ENDIF(BaseSurfaceRenderer_DIR)

#-----------------------------------------------------------------------------
IF(NOT BaseSurfaceRenderer_FOUND)
  # BaseSurfaceRenderer not found, explain to the user how to specify its location.
  IF(NOT BaseSurfaceRenderer_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${BaseSurfaceRenderer_NOT_FOUND_MESSAGE})
  ELSE(NOT BaseSurfaceRenderer_FIND_QUIETLY)
    IF(BaseSurfaceRenderer_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${BaseSurfaceRenderer_NOT_FOUND_MESSAGE})
    ENDIF(BaseSurfaceRenderer_FIND_REQUIRED)
  ENDIF(NOT BaseSurfaceRenderer_FIND_QUIETLY)
ENDIF(NOT BaseSurfaceRenderer_FOUND)
