# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbPackRecalage is found.  
# If bbPackRecalage is not found, bbPackRecalage_FOUND is set to false.
#  bbPackRecalage_FOUND         - Set to true when bbPackRecalage is found.
#  bbPackRecalage_USE_FILE      - CMake file to use bbPackRecalage.
#  bbPackRecalage_MAJOR_VERSION - The bbPackRecalage major version number.
#  bbPackRecalage_MINOR_VERSION - The bbPackRecalage minor version number 
#                       (odd non-release).
#  bbPackRecalage_BUILD_VERSION - The bbPackRecalage patch level 
#                       (meaningless for odd minor).
#  bbPackRecalage_INCLUDE_DIRS  - Include directories for bbPackRecalage
#  bbPackRecalage_LIBRARY_DIRS  - Link directories for bbPackRecalage libraries
#  bbPackRecalage_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbPackRecalage:
#  bbPackRecalage_DIR  - The directory containing bbPackRecalageConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbPackRecalage directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbPackRecalage_DIR_DESCRIPTION "directory containing bbPackRecalageConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbPackRecalage for an installation.")
SET(bbPackRecalage_NOT_FOUND_MESSAGE "bbPackRecalage not found.  Set the bbPackRecalage_DIR cmake cache entry to the ${bbPackRecalage_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbPackRecalage_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbPackRecalage_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbPackRecalage_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbPackRecalage_DIR_SEARCH2 "${bbPackRecalage_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbPackRecalage_DIR_SEARCH "")
  FOREACH(dir ${bbPackRecalage_DIR_SEARCH2})
    SET(bbPackRecalage_DIR_SEARCH ${bbPackRecalage_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbPackRecalage
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbPackRecalage_DIR UsebbPackRecalage.cmake
    # Look for an environment variable bbPackRecalage_DIR.
    $ENV{bbPackRecalage_DIR}

    # Look in places relative to the system executable search path.
    ${bbPackRecalage_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbPackRecalage"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbPackRecalage
    /usr/lib64/creatools/bbPackRecalage

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbPackRecalage will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbPackRecalage_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbPackRecalage_DIR)

# If bbPackRecalage was found, load the configuration file to get the rest of the
# settings.
IF(bbPackRecalage_DIR)
  # Make sure the bbPackRecalageConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbPackRecalage_DIR}/bbPackRecalageConfig.cmake)

    # We found bbPackRecalage.  Load the settings.
    SET(bbPackRecalage_FOUND 1)
    INCLUDE(${bbPackRecalage_DIR}/bbPackRecalageConfig.cmake)

  ENDIF(EXISTS ${bbPackRecalage_DIR}/bbPackRecalageConfig.cmake)
ELSE(bbPackRecalage_DIR)
  # We did not find bbPackRecalage.
  SET(bbPackRecalage_FOUND 0)
ENDIF(bbPackRecalage_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbPackRecalage_FOUND)
  # bbPackRecalage not found, explain to the user how to specify its location.
  IF(NOT bbPackRecalage_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbPackRecalage_NOT_FOUND_MESSAGE})
  ELSE(NOT bbPackRecalage_FIND_QUIETLY)
    IF(bbPackRecalage_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbPackRecalage_NOT_FOUND_MESSAGE})
    ENDIF(bbPackRecalage_FIND_REQUIRED)
  ENDIF(NOT bbPackRecalage_FIND_QUIETLY)
ENDIF(NOT bbPackRecalage_FOUND)
