# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbcreaImageIO is found.  
# If bbcreaImageIO is not found, bbcreaImageIO_FOUND is set to false.
#  bbcreaImageIO_FOUND         - Set to true when bbcreaImageIO is found.
#  bbcreaImageIO_USE_FILE      - CMake file to use bbcreaImageIO.
#  bbcreaImageIO_MAJOR_VERSION - The bbcreaImageIO major version number.
#  bbcreaImageIO_MINOR_VERSION - The bbcreaImageIO minor version number 
#                       (odd non-release).
#  bbcreaImageIO_BUILD_VERSION - The bbcreaImageIO patch level 
#                       (meaningless for odd minor).
#  bbcreaImageIO_INCLUDE_DIRS  - Include directories for bbcreaImageIO
#  bbcreaImageIO_LIBRARY_DIRS  - Link directories for bbcreaImageIO libraries
#  bbcreaImageIO_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbcreaImageIO:
#  bbcreaImageIO_DIR  - The directory containing bbcreaImageIOConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbcreaImageIO directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbcreaImageIO_DIR_DESCRIPTION "directory containing bbcreaImageIOConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbcreaImageIO for an installation.")
SET(bbcreaImageIO_NOT_FOUND_MESSAGE "bbcreaImageIO not found.  Set the bbcreaImageIO_DIR cmake cache entry to the ${bbcreaImageIO_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbcreaImageIO_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbcreaImageIO_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbcreaImageIO_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbcreaImageIO_DIR_SEARCH2 "${bbcreaImageIO_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbcreaImageIO_DIR_SEARCH "")
  FOREACH(dir ${bbcreaImageIO_DIR_SEARCH2})
    SET(bbcreaImageIO_DIR_SEARCH ${bbcreaImageIO_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbcreaImageIO
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbcreaImageIO_DIR UsebbcreaImageIO.cmake
    # Look for an environment variable bbcreaImageIO_DIR.
    $ENV{bbcreaImageIO_DIR}

    # Look in places relative to the system executable search path.
    ${bbcreaImageIO_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbcreaImageIO"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbcreaImageIO
    /usr/lib64/creatools/bbcreaImageIO

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbcreaImageIO will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbcreaImageIO_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbcreaImageIO_DIR)

# If bbcreaImageIO was found, load the configuration file to get the rest of the
# settings.
IF(bbcreaImageIO_DIR)
  # Make sure the bbcreaImageIOConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbcreaImageIO_DIR}/bbcreaImageIOConfig.cmake)

    # We found bbcreaImageIO.  Load the settings.
    SET(bbcreaImageIO_FOUND 1)
    INCLUDE(${bbcreaImageIO_DIR}/bbcreaImageIOConfig.cmake)

  ENDIF(EXISTS ${bbcreaImageIO_DIR}/bbcreaImageIOConfig.cmake)
ELSE(bbcreaImageIO_DIR)
  # We did not find bbcreaImageIO.
  SET(bbcreaImageIO_FOUND 0)
ENDIF(bbcreaImageIO_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbcreaImageIO_FOUND)
  # bbcreaImageIO not found, explain to the user how to specify its location.
  IF(NOT bbcreaImageIO_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbcreaImageIO_NOT_FOUND_MESSAGE})
  ELSE(NOT bbcreaImageIO_FIND_QUIETLY)
    IF(bbcreaImageIO_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbcreaImageIO_NOT_FOUND_MESSAGE})
    ENDIF(bbcreaImageIO_FIND_REQUIRED)
  ENDIF(NOT bbcreaImageIO_FIND_QUIETLY)
ENDIF(NOT bbcreaImageIO_FOUND)
