# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbcreaMaracasVisu is found.  
# If bbcreaMaracasVisu is not found, bbcreaMaracasVisu_FOUND is set to false.
#  bbcreaMaracasVisu_FOUND         - Set to true when bbcreaMaracasVisu is found.
#  bbcreaMaracasVisu_USE_FILE      - CMake file to use bbcreaMaracasVisu.
#  bbcreaMaracasVisu_MAJOR_VERSION - The bbcreaMaracasVisu major version number.
#  bbcreaMaracasVisu_MINOR_VERSION - The bbcreaMaracasVisu minor version number 
#                       (odd non-release).
#  bbcreaMaracasVisu_BUILD_VERSION - The bbcreaMaracasVisu patch level 
#                       (meaningless for odd minor).
#  bbcreaMaracasVisu_INCLUDE_DIRS  - Include directories for bbcreaMaracasVisu
#  bbcreaMaracasVisu_LIBRARY_DIRS  - Link directories for bbcreaMaracasVisu libraries
#  bbcreaMaracasVisu_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbcreaMaracasVisu:
#  bbcreaMaracasVisu_DIR  - The directory containing bbcreaMaracasVisuConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbcreaMaracasVisu directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbcreaMaracasVisu_DIR_DESCRIPTION "directory containing bbcreaMaracasVisuConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbcreaMaracasVisu for an installation.")
SET(bbcreaMaracasVisu_NOT_FOUND_MESSAGE "bbcreaMaracasVisu not found.  Set the bbcreaMaracasVisu_DIR cmake cache entry to the ${bbcreaMaracasVisu_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbcreaMaracasVisu_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbcreaMaracasVisu_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbcreaMaracasVisu_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbcreaMaracasVisu_DIR_SEARCH2 "${bbcreaMaracasVisu_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbcreaMaracasVisu_DIR_SEARCH "")
  FOREACH(dir ${bbcreaMaracasVisu_DIR_SEARCH2})
    SET(bbcreaMaracasVisu_DIR_SEARCH ${bbcreaMaracasVisu_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbcreaMaracasVisu
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbcreaMaracasVisu_DIR UsebbcreaMaracasVisu.cmake
    # Look for an environment variable bbcreaMaracasVisu_DIR.
    $ENV{bbcreaMaracasVisu_DIR}

    # Look in places relative to the system executable search path.
    ${bbcreaMaracasVisu_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbcreaMaracasVisu"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbcreaMaracasVisu
    /usr/lib64/creatools/bbcreaMaracasVisu

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbcreaMaracasVisu will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbcreaMaracasVisu_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbcreaMaracasVisu_DIR)

# If bbcreaMaracasVisu was found, load the configuration file to get the rest of the
# settings.
IF(bbcreaMaracasVisu_DIR)
  # Make sure the bbcreaMaracasVisuConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbcreaMaracasVisu_DIR}/bbcreaMaracasVisuConfig.cmake)

    # We found bbcreaMaracasVisu.  Load the settings.
    SET(bbcreaMaracasVisu_FOUND 1)
    INCLUDE(${bbcreaMaracasVisu_DIR}/bbcreaMaracasVisuConfig.cmake)

  ENDIF(EXISTS ${bbcreaMaracasVisu_DIR}/bbcreaMaracasVisuConfig.cmake)
ELSE(bbcreaMaracasVisu_DIR)
  # We did not find bbcreaMaracasVisu.
  SET(bbcreaMaracasVisu_FOUND 0)
ENDIF(bbcreaMaracasVisu_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbcreaMaracasVisu_FOUND)
  # bbcreaMaracasVisu not found, explain to the user how to specify its location.
  IF(NOT bbcreaMaracasVisu_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbcreaMaracasVisu_NOT_FOUND_MESSAGE})
  ELSE(NOT bbcreaMaracasVisu_FIND_QUIETLY)
    IF(bbcreaMaracasVisu_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbcreaMaracasVisu_NOT_FOUND_MESSAGE})
    ENDIF(bbcreaMaracasVisu_FIND_REQUIRED)
  ENDIF(NOT bbcreaMaracasVisu_FIND_QUIETLY)
ENDIF(NOT bbcreaMaracasVisu_FOUND)
