# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbcreaMiniTools is found.  
# If bbcreaMiniTools is not found, bbcreaMiniTools_FOUND is set to false.
#  bbcreaMiniTools_FOUND         - Set to true when bbcreaMiniTools is found.
#  bbcreaMiniTools_USE_FILE      - CMake file to use bbcreaMiniTools.
#  bbcreaMiniTools_MAJOR_VERSION - The bbcreaMiniTools major version number.
#  bbcreaMiniTools_MINOR_VERSION - The bbcreaMiniTools minor version number 
#                       (odd non-release).
#  bbcreaMiniTools_BUILD_VERSION - The bbcreaMiniTools patch level 
#                       (meaningless for odd minor).
#  bbcreaMiniTools_INCLUDE_DIRS  - Include directories for bbcreaMiniTools
#  bbcreaMiniTools_LIBRARY_DIRS  - Link directories for bbcreaMiniTools libraries
#  bbcreaMiniTools_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbcreaMiniTools:
#  bbcreaMiniTools_DIR  - The directory containing bbcreaMiniToolsConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbcreaMiniTools directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbcreaMiniTools_DIR_DESCRIPTION "directory containing bbcreaMiniToolsConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbcreaMiniTools for an installation.")
SET(bbcreaMiniTools_NOT_FOUND_MESSAGE "bbcreaMiniTools not found.  Set the bbcreaMiniTools_DIR cmake cache entry to the ${bbcreaMiniTools_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbcreaMiniTools_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbcreaMiniTools_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbcreaMiniTools_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbcreaMiniTools_DIR_SEARCH2 "${bbcreaMiniTools_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbcreaMiniTools_DIR_SEARCH "")
  FOREACH(dir ${bbcreaMiniTools_DIR_SEARCH2})
    SET(bbcreaMiniTools_DIR_SEARCH ${bbcreaMiniTools_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbcreaMiniTools
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbcreaMiniTools_DIR UsebbcreaMiniTools.cmake
    # Look for an environment variable bbcreaMiniTools_DIR.
    $ENV{bbcreaMiniTools_DIR}

    # Look in places relative to the system executable search path.
    ${bbcreaMiniTools_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbcreaMiniTools"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbcreaMiniTools
    /usr/lib64/creatools/bbcreaMiniTools

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbcreaMiniTools will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbcreaMiniTools_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbcreaMiniTools_DIR)

# If bbcreaMiniTools was found, load the configuration file to get the rest of the
# settings.
IF(bbcreaMiniTools_DIR)
  # Make sure the bbcreaMiniToolsConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbcreaMiniTools_DIR}/bbcreaMiniToolsConfig.cmake)

    # We found bbcreaMiniTools.  Load the settings.
    SET(bbcreaMiniTools_FOUND 1)
    INCLUDE(${bbcreaMiniTools_DIR}/bbcreaMiniToolsConfig.cmake)

  ENDIF(EXISTS ${bbcreaMiniTools_DIR}/bbcreaMiniToolsConfig.cmake)
ELSE(bbcreaMiniTools_DIR)
  # We did not find bbcreaMiniTools.
  SET(bbcreaMiniTools_FOUND 0)
ENDIF(bbcreaMiniTools_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbcreaMiniTools_FOUND)
  # bbcreaMiniTools not found, explain to the user how to specify its location.
  IF(NOT bbcreaMiniTools_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbcreaMiniTools_NOT_FOUND_MESSAGE})
  ELSE(NOT bbcreaMiniTools_FIND_QUIETLY)
    IF(bbcreaMiniTools_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbcreaMiniTools_NOT_FOUND_MESSAGE})
    ENDIF(bbcreaMiniTools_FIND_REQUIRED)
  ENDIF(NOT bbcreaMiniTools_FIND_QUIETLY)
ENDIF(NOT bbcreaMiniTools_FOUND)
