# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbcreaVtk is found.  
# If bbcreaVtk is not found, bbcreaVtk_FOUND is set to false.
#  bbcreaVtk_FOUND         - Set to true when bbcreaVtk is found.
#  bbcreaVtk_USE_FILE      - CMake file to use bbcreaVtk.
#  bbcreaVtk_MAJOR_VERSION - The bbcreaVtk major version number.
#  bbcreaVtk_MINOR_VERSION - The bbcreaVtk minor version number 
#                       (odd non-release).
#  bbcreaVtk_BUILD_VERSION - The bbcreaVtk patch level 
#                       (meaningless for odd minor).
#  bbcreaVtk_INCLUDE_DIRS  - Include directories for bbcreaVtk
#  bbcreaVtk_LIBRARY_DIRS  - Link directories for bbcreaVtk libraries
#  bbcreaVtk_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbcreaVtk:
#  bbcreaVtk_DIR  - The directory containing bbcreaVtkConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbcreaVtk directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbcreaVtk_DIR_DESCRIPTION "directory containing bbcreaVtkConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbcreaVtk for an installation.")
SET(bbcreaVtk_NOT_FOUND_MESSAGE "bbcreaVtk not found.  Set the bbcreaVtk_DIR cmake cache entry to the ${bbcreaVtk_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbcreaVtk_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbcreaVtk_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbcreaVtk_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbcreaVtk_DIR_SEARCH2 "${bbcreaVtk_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbcreaVtk_DIR_SEARCH "")
  FOREACH(dir ${bbcreaVtk_DIR_SEARCH2})
    SET(bbcreaVtk_DIR_SEARCH ${bbcreaVtk_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbcreaVtk
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbcreaVtk_DIR UsebbcreaVtk.cmake
    # Look for an environment variable bbcreaVtk_DIR.
    $ENV{bbcreaVtk_DIR}

    # Look in places relative to the system executable search path.
    ${bbcreaVtk_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbcreaVtk"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbcreaVtk
    /usr/lib64/creatools/bbcreaVtk

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbcreaVtk will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbcreaVtk_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbcreaVtk_DIR)

# If bbcreaVtk was found, load the configuration file to get the rest of the
# settings.
IF(bbcreaVtk_DIR)
  # Make sure the bbcreaVtkConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbcreaVtk_DIR}/bbcreaVtkConfig.cmake)

    # We found bbcreaVtk.  Load the settings.
    SET(bbcreaVtk_FOUND 1)
    INCLUDE(${bbcreaVtk_DIR}/bbcreaVtkConfig.cmake)

  ENDIF(EXISTS ${bbcreaVtk_DIR}/bbcreaVtkConfig.cmake)
ELSE(bbcreaVtk_DIR)
  # We did not find bbcreaVtk.
  SET(bbcreaVtk_FOUND 0)
ENDIF(bbcreaVtk_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbcreaVtk_FOUND)
  # bbcreaVtk not found, explain to the user how to specify its location.
  IF(NOT bbcreaVtk_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbcreaVtk_NOT_FOUND_MESSAGE})
  ELSE(NOT bbcreaVtk_FIND_QUIETLY)
    IF(bbcreaVtk_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbcreaVtk_NOT_FOUND_MESSAGE})
    ENDIF(bbcreaVtk_FIND_REQUIRED)
  ENDIF(NOT bbcreaVtk_FIND_QUIETLY)
ENDIF(NOT bbcreaVtk_FOUND)
