# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbdemo is found.  
# If bbdemo is not found, bbdemo_FOUND is set to false.
#  bbdemo_FOUND         - Set to true when bbdemo is found.
#  bbdemo_USE_FILE      - CMake file to use bbdemo.
#  bbdemo_MAJOR_VERSION - The bbdemo major version number.
#  bbdemo_MINOR_VERSION - The bbdemo minor version number 
#                       (odd non-release).
#  bbdemo_BUILD_VERSION - The bbdemo patch level 
#                       (meaningless for odd minor).
#  bbdemo_INCLUDE_DIRS  - Include directories for bbdemo
#  bbdemo_LIBRARY_DIRS  - Link directories for bbdemo libraries
#  bbdemo_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbdemo:
#  bbdemo_DIR  - The directory containing bbdemoConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbdemo directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbdemo_DIR_DESCRIPTION "directory containing bbdemoConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbdemo for an installation.")
SET(bbdemo_NOT_FOUND_MESSAGE "bbdemo not found.  Set the bbdemo_DIR cmake cache entry to the ${bbdemo_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbdemo_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbdemo_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbdemo_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbdemo_DIR_SEARCH2 "${bbdemo_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbdemo_DIR_SEARCH "")
  FOREACH(dir ${bbdemo_DIR_SEARCH2})
    SET(bbdemo_DIR_SEARCH ${bbdemo_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbdemo
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbdemo_DIR Usebbdemo.cmake
    # Look for an environment variable bbdemo_DIR.
    $ENV{bbdemo_DIR}

    # Look in places relative to the system executable search path.
    ${bbdemo_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbdemo"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbdemo
    /usr/lib64/creatools/bbdemo

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbdemo will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbdemo_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbdemo_DIR)

# If bbdemo was found, load the configuration file to get the rest of the
# settings.
IF(bbdemo_DIR)
  # Make sure the bbdemoConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbdemo_DIR}/bbdemoConfig.cmake)

    # We found bbdemo.  Load the settings.
    SET(bbdemo_FOUND 1)
    INCLUDE(${bbdemo_DIR}/bbdemoConfig.cmake)

  ENDIF(EXISTS ${bbdemo_DIR}/bbdemoConfig.cmake)
ELSE(bbdemo_DIR)
  # We did not find bbdemo.
  SET(bbdemo_FOUND 0)
ENDIF(bbdemo_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbdemo_FOUND)
  # bbdemo not found, explain to the user how to specify its location.
  IF(NOT bbdemo_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbdemo_NOT_FOUND_MESSAGE})
  ELSE(NOT bbdemo_FIND_QUIETLY)
    IF(bbdemo_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbdemo_NOT_FOUND_MESSAGE})
    ENDIF(bbdemo_FIND_REQUIRED)
  ENDIF(NOT bbdemo_FIND_QUIETLY)
ENDIF(NOT bbdemo_FOUND)
