# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbitkvtk is found.  
# If bbitkvtk is not found, bbitkvtk_FOUND is set to false.
#  bbitkvtk_FOUND         - Set to true when bbitkvtk is found.
#  bbitkvtk_USE_FILE      - CMake file to use bbitkvtk.
#  bbitkvtk_MAJOR_VERSION - The bbitkvtk major version number.
#  bbitkvtk_MINOR_VERSION - The bbitkvtk minor version number 
#                       (odd non-release).
#  bbitkvtk_BUILD_VERSION - The bbitkvtk patch level 
#                       (meaningless for odd minor).
#  bbitkvtk_INCLUDE_DIRS  - Include directories for bbitkvtk
#  bbitkvtk_LIBRARY_DIRS  - Link directories for bbitkvtk libraries
#  bbitkvtk_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbitkvtk:
#  bbitkvtk_DIR  - The directory containing bbitkvtkConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbitkvtk directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbitkvtk_DIR_DESCRIPTION "directory containing bbitkvtkConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbitkvtk for an installation.")
SET(bbitkvtk_NOT_FOUND_MESSAGE "bbitkvtk not found.  Set the bbitkvtk_DIR cmake cache entry to the ${bbitkvtk_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbitkvtk_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbitkvtk_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbitkvtk_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbitkvtk_DIR_SEARCH2 "${bbitkvtk_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbitkvtk_DIR_SEARCH "")
  FOREACH(dir ${bbitkvtk_DIR_SEARCH2})
    SET(bbitkvtk_DIR_SEARCH ${bbitkvtk_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbitkvtk
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbitkvtk_DIR Usebbitkvtk.cmake
    # Look for an environment variable bbitkvtk_DIR.
    $ENV{bbitkvtk_DIR}

    # Look in places relative to the system executable search path.
    ${bbitkvtk_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbitkvtk"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbitkvtk
    /usr/lib64/creatools/bbitkvtk

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbitkvtk will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbitkvtk_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbitkvtk_DIR)

# If bbitkvtk was found, load the configuration file to get the rest of the
# settings.
IF(bbitkvtk_DIR)
  # Make sure the bbitkvtkConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbitkvtk_DIR}/bbitkvtkConfig.cmake)

    # We found bbitkvtk.  Load the settings.
    SET(bbitkvtk_FOUND 1)
    INCLUDE(${bbitkvtk_DIR}/bbitkvtkConfig.cmake)

  ENDIF(EXISTS ${bbitkvtk_DIR}/bbitkvtkConfig.cmake)
ELSE(bbitkvtk_DIR)
  # We did not find bbitkvtk.
  SET(bbitkvtk_FOUND 0)
ENDIF(bbitkvtk_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbitkvtk_FOUND)
  # bbitkvtk not found, explain to the user how to specify its location.
  IF(NOT bbitkvtk_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbitkvtk_NOT_FOUND_MESSAGE})
  ELSE(NOT bbitkvtk_FIND_QUIETLY)
    IF(bbitkvtk_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbitkvtk_NOT_FOUND_MESSAGE})
    ENDIF(bbitkvtk_FIND_REQUIRED)
  ENDIF(NOT bbitkvtk_FIND_QUIETLY)
ENDIF(NOT bbitkvtk_FOUND)
